/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.internal;

import javax.annotation.Nonnull;
import org.sonatype.nexus.repository.cache.CacheControllerHolder;

public enum AssetKind {
    HELM_INDEX(CacheControllerHolder.METADATA, ".yaml"),
    HELM_PROVENANCE(CacheControllerHolder.CONTENT, ".tgz.prov"),
    HELM_PACKAGE(CacheControllerHolder.CONTENT, ".tgz");

    private final CacheControllerHolder.CacheType cacheType;
    private final String extension;

    private AssetKind(CacheControllerHolder.CacheType cacheType, String extension) {
        this.cacheType = cacheType;
        this.extension = extension;
    }

    public static AssetKind getAssetKindByFileName(String name) {
        if (name.endsWith(HELM_PACKAGE.getExtension())) {
            return HELM_PACKAGE;
        }
        if (name.endsWith(HELM_PROVENANCE.getExtension())) {
            return HELM_PROVENANCE;
        }
        return HELM_INDEX;
    }

    @Nonnull
    public CacheControllerHolder.CacheType getCacheType() {
        return this.cacheType;
    }

    @Nonnull
    public String getExtension() {
        return this.extension;
    }
}

