/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.datastore.internal.restore;

import com.sonatype.repository.helm.datastore.HelmRestoreFacet;
import com.sonatype.repository.helm.datastore.internal.HelmContentFacet;
import com.sonatype.repository.helm.internal.AssetKind;
import java.io.IOException;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.DetachedBlobPayload;

@Named
public class HelmRestoreFacetImpl
extends FacetSupport
implements HelmRestoreFacet {
    @Override
    public void restore(Blob blob, String path) throws IOException {
        AssetKind assetKind = AssetKind.getAssetKindByFileName(path);
        if (assetKind != AssetKind.HELM_PACKAGE && assetKind != AssetKind.HELM_PROVENANCE) {
            throw new IllegalArgumentException("Unsupported assetKind: " + (Object)((Object)assetKind));
        }
        this.content().putComponent(path, (Payload)new DetachedBlobPayload(blob), assetKind);
    }

    @Override
    public boolean isRestorable(String name) {
        return AssetKind.getAssetKindByFileName(name) != AssetKind.HELM_INDEX;
    }

    private HelmContentFacet content() {
        return (HelmContentFacet)this.facet(HelmContentFacet.class);
    }
}

