/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.datastore.internal.recipe;

import com.google.common.base.Preconditions;
import com.sonatype.repository.helm.datastore.internal.HelmContentFacet;
import com.sonatype.repository.helm.internal.AssetKind;
import com.sonatype.repository.helm.internal.metadata.IndexYamlAbsoluteUrlRewriter;
import com.sonatype.repository.helm.internal.util.HelmPathUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.content.facet.ContentProxyFacetSupport;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
public class HelmProxyFacet
extends ContentProxyFacetSupport {
    private final HelmPathUtils helmPathUtils;
    private final IndexYamlAbsoluteUrlRewriter indexYamlRewriter;
    private static final String INDEX_YAML = "/index.yaml";

    @Inject
    public HelmProxyFacet(HelmPathUtils helmPathUtils, IndexYamlAbsoluteUrlRewriter indexYamlRewriter) {
        this.helmPathUtils = (HelmPathUtils)((Object)Preconditions.checkNotNull((Object)((Object)helmPathUtils)));
        this.indexYamlRewriter = (IndexYamlAbsoluteUrlRewriter)((Object)Preconditions.checkNotNull((Object)((Object)indexYamlRewriter)));
    }

    @Nullable
    protected Content getCachedContent(Context context) {
        Content content = this.content().getAsset(this.getAssetPath(context)).orElse(null);
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return assetKind == AssetKind.HELM_INDEX ? this.indexYamlRewriter.removeUrlsFromIndexYaml(content) : content;
    }

    @Nonnull
    protected CacheController getCacheController(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return this.cacheControllerHolder.require(assetKind.getCacheType());
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        switch (assetKind) {
            case HELM_INDEX: {
                return this.content().putIndex(this.getAssetPath(context), content, assetKind);
            }
            case HELM_PACKAGE: {
                return this.content().putComponent(this.getAssetPath(context), (Payload)content, assetKind);
            }
        }
        throw new IllegalStateException("Received an invalid AssetKind of type: " + assetKind.name());
    }

    private String getAssetPath(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        switch (assetKind) {
            case HELM_INDEX: {
                return INDEX_YAML;
            }
            case HELM_PACKAGE: {
                TokenMatcher.State matcherState = this.helmPathUtils.matcherState(context);
                return this.helmPathUtils.contentFilePath(matcherState, true);
            }
        }
        throw new IllegalStateException("Received an invalid AssetKind of type: " + assetKind.name());
    }

    protected String getUrl(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        switch (assetKind) {
            case HELM_INDEX: {
                return "index.yaml";
            }
            case HELM_PACKAGE: {
                TokenMatcher.State matcherState = this.helmPathUtils.matcherState(context);
                Optional<Content> indexOpt = this.content().getAsset(INDEX_YAML);
                if (!indexOpt.isPresent()) {
                    this.log.info("Try to refetch index.yml file in repository: {}", (Object)this.getRepository().getName());
                    indexOpt = this.fetchIndexYamlContext(context);
                }
                if (!indexOpt.isPresent()) {
                    this.log.error("index.yml file is absent in repository: {}", (Object)this.getRepository().getName());
                    return null;
                }
                String filename = this.helmPathUtils.filename(matcherState);
                return this.helmPathUtils.contentFileUrl(filename, indexOpt.get()).orElse(this.getRequestUrl(context));
            }
        }
        throw new IllegalStateException("Received an invalid AssetKind of type: " + assetKind.name());
    }

    private String getRequestUrl(@Nonnull Context context) {
        return StringUtils.removeStart((String)context.getRequest().getPath(), (String)"/");
    }

    private Optional<Content> fetchIndexYamlContext(@Nonnull Context context) {
        Context indexYamlContext = this.buildContextForRepositoryIndexYaml(context);
        try {
            this.get(indexYamlContext);
            return this.content().getAsset(INDEX_YAML);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Context buildContextForRepositoryIndexYaml(Context contextPackage) {
        Repository repository = contextPackage.getRepository();
        Request request = new Request.Builder().action(contextPackage.getRequest().getAction()).path(INDEX_YAML).build();
        Context indexYamlContext = new Context(repository, request);
        indexYamlContext.getAttributes().backing().putAll(contextPackage.getAttributes().backing());
        indexYamlContext.getAttributes().set(AssetKind.class, (Object)AssetKind.HELM_INDEX);
        return indexYamlContext;
    }

    private HelmContentFacet content() {
        return (HelmContentFacet)this.getRepository().facet(HelmContentFacet.class);
    }
}

