/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.datastore.internal.recipe;

import com.google.common.base.Preconditions;
import com.sonatype.repository.helm.HelmAttributes;
import com.sonatype.repository.helm.datastore.internal.HelmContentFacet;
import com.sonatype.repository.helm.datastore.internal.recipe.HelmHostedFacet;
import com.sonatype.repository.helm.internal.AssetKind;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named
public class HelmHostedFacetImpl
extends FacetSupport
implements HelmHostedFacet {
    private HelmContentFacet helmContentFacet;

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.helmContentFacet = (HelmContentFacet)this.facet(HelmContentFacet.class);
    }

    @Override
    @Nullable
    public Content get(String path) {
        Preconditions.checkNotNull((Object)path);
        return this.helmContentFacet.getAsset(path).orElse(null);
    }

    @Override
    public String getPath(HelmAttributes attributes, AssetKind assetKind) {
        if (assetKind != AssetKind.HELM_PACKAGE && assetKind != AssetKind.HELM_PROVENANCE) {
            throw new IllegalArgumentException("Unsupported assetKind: " + (Object)((Object)assetKind));
        }
        String extension = assetKind.getExtension();
        String name = attributes.getName();
        String version = attributes.getVersion();
        return String.format("/%s-%s%s", name, version, extension);
    }

    @Override
    public void upload(String path, Payload payload, AssetKind assetKind) throws IOException {
        Preconditions.checkNotNull((Object)path);
        if (assetKind != AssetKind.HELM_PACKAGE && assetKind != AssetKind.HELM_PROVENANCE) {
            throw new IllegalArgumentException("Unsupported assetKind: " + (Object)((Object)assetKind));
        }
        this.helmContentFacet.putComponent(path, (Payload)new Content(payload), assetKind);
    }

    @Override
    public Content upload(String path, TempBlob tempBlob, HelmAttributes helmAttributes, Payload payload, AssetKind assetKind) {
        Preconditions.checkNotNull((Object)path);
        if (assetKind != AssetKind.HELM_PACKAGE && assetKind != AssetKind.HELM_PROVENANCE) {
            throw new IllegalArgumentException("Unsupported assetKind: " + (Object)((Object)assetKind));
        }
        return this.helmContentFacet.putComponent(path, tempBlob, helmAttributes, new Content(payload), assetKind);
    }

    @Override
    public boolean delete(String path) {
        Preconditions.checkNotNull((Object)path);
        return this.helmContentFacet.delete(path);
    }
}

