/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.datastore.internal.createindex;

import com.google.common.base.Preconditions;
import com.sonatype.repository.helm.datastore.internal.HelmContentFacet;
import com.sonatype.repository.helm.datastore.internal.createindex.CreateIndexService;
import com.sonatype.repository.helm.internal.AssetKind;
import com.sonatype.repository.helm.internal.database.HelmProperties;
import com.sonatype.repository.helm.internal.metadata.ChartEntry;
import com.sonatype.repository.helm.internal.metadata.ChartIndex;
import com.sonatype.repository.helm.internal.util.YamlParser;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class CreateIndexServiceImpl
extends ComponentSupport
implements CreateIndexService {
    private static final String API_VERSION = "v1";
    private static final String INDEX_YAML_CONTENT_TYPE = "text/x-yaml";
    private final YamlParser yamlParser;

    @Inject
    public CreateIndexServiceImpl(YamlParser yamlParser) {
        this.yamlParser = (YamlParser)((Object)Preconditions.checkNotNull((Object)((Object)yamlParser)));
    }

    @Override
    @Nullable
    public Content buildIndexYaml(Repository repository) {
        HelmContentFacet helmFacet = (HelmContentFacet)repository.facet(HelmContentFacet.class);
        ChartIndex index = new ChartIndex();
        for (Asset asset : helmFacet.browseAssetsByKind(AssetKind.HELM_PACKAGE)) {
            this.parseAssetIntoChartEntry(index, asset);
        }
        index.setApiVersion(API_VERSION);
        index.setGenerated(new DateTime());
        return new Content((Payload)new StringPayload(this.yamlParser.getYamlContent(index), INDEX_YAML_CONTENT_TYPE));
    }

    private void parseAssetIntoChartEntry(ChartIndex index, Asset asset) {
        NestedAttributesMap formatAttributes = asset.attributes().child("helm");
        if (formatAttributes != null) {
            ChartEntry chartEntry = new ChartEntry();
            chartEntry.setName((String)formatAttributes.get(HelmProperties.NAME.getPropertyName(), String.class));
            chartEntry.setVersion((String)formatAttributes.get(HelmProperties.VERSION.getPropertyName(), String.class));
            chartEntry.setDescription((String)formatAttributes.get(HelmProperties.DESCRIPTION.getPropertyName(), String.class));
            chartEntry.setIcon((String)formatAttributes.get(HelmProperties.ICON.getPropertyName(), String.class));
            chartEntry.setCreated(new DateTime((Object)asset.created().toString()));
            List maintainers = (List)formatAttributes.get(HelmProperties.MAINTAINERS.getPropertyName(), List.class);
            chartEntry.setMaintainers(maintainers);
            chartEntry.setAppVersion((String)formatAttributes.get(HelmProperties.APP_VERSION.getPropertyName(), String.class));
            AssetBlob blob = asset.blob().orElse(null);
            chartEntry.setDigest(blob != null ? (String)blob.checksums().get("sha256") : null);
            this.createListOfRelativeUrls(formatAttributes, chartEntry);
            chartEntry.setSources((List)formatAttributes.get(HelmProperties.SOURCES.getPropertyName(), List.class));
            index.addEntry(chartEntry);
        }
    }

    private void createListOfRelativeUrls(NestedAttributesMap formatAttributes, ChartEntry chartEntry) {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(String.format("%s-%s.tgz", formatAttributes.get(HelmProperties.NAME.getPropertyName(), String.class), formatAttributes.get(HelmProperties.VERSION.getPropertyName(), String.class)));
        chartEntry.setUrls(urls);
    }
}

