/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.datastore.internal.createindex;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.repository.helm.datastore.internal.HelmContentFacet;
import com.sonatype.repository.helm.datastore.internal.createindex.CreateIndexService;
import com.sonatype.repository.helm.datastore.internal.recipe.HelmHostedFacet;
import com.sonatype.repository.helm.internal.AssetKind;
import com.sonatype.repository.helm.internal.createindex.CreateIndexFacet;
import com.sonatype.repository.helm.internal.createindex.HelmIndexInvalidationEvent;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.event.asset.AssetCreatedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetDeletedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetPurgedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetUpdatedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetUploadedEvent;
import org.sonatype.nexus.repository.content.store.ContentStoreEvent;
import org.sonatype.nexus.repository.manager.RepositoryCreatedEvent;
import org.sonatype.nexus.repository.view.Content;

@Named
public class CreateIndexFacetImpl
extends FacetSupport
implements CreateIndexFacet,
EventAware.Asynchronous {
    private static final String INDEX_YAML = "/index.yaml";
    private final EventManager eventManager;
    private final long interval;
    private final AtomicBoolean acceptingEvents = new AtomicBoolean(true);
    private static final String UPDATING_INDEX_LOG = "Updating index.yaml for hosted repository {}";
    private final AtomicBoolean eventFired = new AtomicBoolean(false);
    private CreateIndexService createIndexService;

    @Inject
    public CreateIndexFacetImpl(EventManager eventManager, CreateIndexService createIndexService, @Named(value="${nexus.helm.createrepo.interval:-1000}") long interval) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.interval = interval;
        this.createIndexService = (CreateIndexService)Preconditions.checkNotNull((Object)createIndexService);
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(RepositoryCreatedEvent createdEvent) {
        this.log.debug("Initializing index.yaml for hosted repository {}", (Object)this.getRepository().getName());
        if (this.getRepository().getName().equals(createdEvent.getRepository().getName())) {
            this.invalidateIndex();
        }
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetCreatedEvent created) {
        this.log.debug(UPDATING_INDEX_LOG, (Object)this.getRepository().getName());
        this.maybeInvalidateIndex((AssetEvent)created);
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetDeletedEvent deleted) {
        this.log.debug(UPDATING_INDEX_LOG, (Object)this.getRepository().getName());
        this.maybeInvalidateIndex((AssetEvent)deleted);
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetUpdatedEvent updated) {
        this.log.debug(UPDATING_INDEX_LOG, (Object)this.getRepository().getName());
        this.maybeInvalidateIndex((AssetEvent)updated);
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetUploadedEvent uploaded) {
        this.log.debug(UPDATING_INDEX_LOG, (Object)this.getRepository().getName());
        this.maybeInvalidateIndex((AssetEvent)uploaded);
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetPurgedEvent purged) {
        this.log.debug(UPDATING_INDEX_LOG, (Object)this.getRepository().getName());
        if (this.isRelevantEvent((ContentStoreEvent)purged)) {
            this.invalidateIndex();
        }
    }

    private void maybeInvalidateIndex(AssetEvent event) {
        if (this.isRelevantEvent((ContentStoreEvent)event) && event.getAsset().kind().equals(AssetKind.HELM_PACKAGE.toString())) {
            this.invalidateIndex();
        }
    }

    private boolean isRelevantEvent(ContentStoreEvent event) {
        return event.getRepository().map(Repository::getName).map(name -> name.equals(this.getRepository().getName())).orElse(false);
    }

    @Subscribe
    public void on(HelmIndexInvalidationEvent event) {
        if (this.shouldProcess(event)) {
            this.acceptingEvents.set(false);
            this.maybeWait(event);
            this.log.info("Rebuilding Helm index for repository {}", (Object)this.getRepository().getName());
            try {
                this.acceptingEvents.set(true);
                this.eventFired.set(false);
                this.updateIndexYaml(this.createIndexService.buildIndexYaml(this.getRepository()));
                this.log.info("Finished rebuilding Helm index for repository {}", (Object)this.getRepository().getName());
            }
            catch (Exception e) {
                this.log.error("Error while rebuilding Helm index for repository {}", (Object)this.getRepository().getName(), (Object)e);
            }
        }
    }

    protected void updateIndexYaml(Content indexYaml) throws IOException {
        if (indexYaml == null) {
            this.deleteIndexYaml();
        } else {
            this.createIndexYaml(indexYaml);
        }
    }

    private void createIndexYaml(Content indexYaml) throws IOException {
        Repository repository = this.getRepository();
        HelmContentFacet helmFacet = (HelmContentFacet)repository.facet(HelmContentFacet.class);
        helmFacet.putIndex(INDEX_YAML, indexYaml, AssetKind.HELM_INDEX);
    }

    private void deleteIndexYaml() {
        this.log.debug("Empty index.yaml returned, proceeding to delete asset");
        HelmHostedFacet hosted = (HelmHostedFacet)this.getRepository().facet(HelmHostedFacet.class);
        boolean result = hosted.delete(INDEX_YAML);
        if (result) {
            this.log.info("Deleted index.yaml because of empty asset list");
        } else {
            this.log.warn("Unable to delete index.yaml asset");
        }
    }

    private boolean shouldProcess(HelmIndexInvalidationEvent event) {
        return this.getRepository().getName().equals(event.getRepositoryName());
    }

    private void maybeWait(HelmIndexInvalidationEvent event) {
        if (event.isWaitBeforeRebuild()) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                this.log.warn("Helm invalidation thread interrupted, proceeding with invalidation");
            }
        }
    }

    @Override
    public synchronized void invalidateIndex() {
        if (this.acceptingEvents.get() && !this.eventFired.get()) {
            this.log.info("Scheduling rebuild of Helm metadata to start in {} seconds", (Object)(this.interval / 1000L));
            this.eventFired.set(true);
            this.eventManager.post((Object)new HelmIndexInvalidationEvent(this.getRepository().getName(), true));
        }
    }
}

