/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.datastore.internal;

import com.sonatype.repository.helm.HelmAttributes;
import com.sonatype.repository.helm.HelmUploadHandlerSupport;
import com.sonatype.repository.helm.datastore.internal.HelmContentFacet;
import com.sonatype.repository.helm.datastore.internal.recipe.HelmHostedFacet;
import com.sonatype.repository.helm.internal.AssetKind;
import com.sonatype.repository.helm.internal.util.HelmAttributeParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Singleton
@Named(value="helm")
public class HelmUploadHandler
extends HelmUploadHandlerSupport {
    @Inject
    public HelmUploadHandler(ContentPermissionChecker contentPermissionChecker, HelmAttributeParser helmPackageParser, @Named(value="simple") VariableResolverAdapter variableResolverAdapter, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(contentPermissionChecker, helmPackageParser, variableResolverAdapter, uploadDefinitionExtensions);
    }

    /*
     * Loose catch block
     */
    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        HelmHostedFacet facet = (HelmHostedFacet)repository.facet(HelmHostedFacet.class);
        HelmContentFacet helmContentFacet = (HelmContentFacet)repository.facet(HelmContentFacet.class);
        PartPayload payload = ((AssetUpload)upload.getAssetUploads().get(0)).getPayload();
        String fileName = payload.getName() != null ? payload.getName() : "";
        AssetKind assetKind = AssetKind.getAssetKindByFileName(fileName);
        Throwable throwable = null;
        Object var9_10 = null;
        try {
            UploadResponse uploadResponse;
            InputStream inputStream;
            TempBlob tempBlob;
            block16: {
                block15: {
                    tempBlob = helmContentFacet.getTempBlob((Payload)payload);
                    inputStream = tempBlob.get();
                    HelmAttributes attributes = HelmAttributeParser.validateAttributes(this.helmPackageParser.getAttributes(assetKind, inputStream));
                    String path = facet.getPath(attributes, assetKind);
                    this.ensurePermitted(repository.getName(), "helm", path, Collections.emptyMap());
                    Content content = facet.upload(path, tempBlob, attributes, (Payload)payload, assetKind);
                    uploadResponse = new UploadResponse(Collections.singletonList(content), Collections.singletonList(path));
                    if (inputStream == null) break block15;
                    inputStream.close();
                }
                if (tempBlob == null) break block16;
                tempBlob.close();
            }
            return uploadResponse;
            {
                catch (Throwable throwable2) {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (tempBlob != null) {
                            tempBlob.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            this.definition = this.getDefinition("helm", false);
        }
        return this.definition;
    }

    @Override
    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    @Override
    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }
}

