/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm;

import com.sonatype.repository.helm.internal.database.HelmProperties;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sonatype.nexus.common.collect.NestedAttributesMap;

public class HelmAttributes {
    private final Map<HelmProperties, Object> attributesEnumMap = new EnumMap<HelmProperties, Object>(HelmProperties.class);

    public HelmAttributes() {
    }

    public HelmAttributes(Map<String, Object> attributesMap) {
        attributesMap.forEach((key, value) -> {
            Optional<HelmProperties> propertyOpt = HelmProperties.findByPropertyName(key);
            if (value != null && propertyOpt.isPresent()) {
                this.attributesEnumMap.put(propertyOpt.get(), value);
            }
        });
    }

    public void populate(NestedAttributesMap attributesMap) {
        this.attributesEnumMap.forEach((helmProperties, o) -> {
            Object object = attributesMap.set(helmProperties.getPropertyName(), o);
        });
    }

    public String getName() {
        return this.getValue(HelmProperties.NAME, String.class);
    }

    public String getVersion() {
        return this.getValue(HelmProperties.VERSION, String.class);
    }

    public String getAppVersion() {
        return this.getValue(HelmProperties.APP_VERSION, String.class);
    }

    public String getDescription() {
        return this.getValue(HelmProperties.DESCRIPTION, String.class);
    }

    public String getIcon() {
        return this.getValue(HelmProperties.ICON, String.class);
    }

    public String getEngine() {
        return this.getValue(HelmProperties.ENGINE, String.class);
    }

    public List<String> getKeywords() {
        return this.getValue(HelmProperties.KEYWORDS, List.class);
    }

    public List<Map<String, String>> getMaintainers() {
        return this.getValue(HelmProperties.MAINTAINERS, List.class);
    }

    public List<String> getSources() {
        return this.getValue(HelmProperties.SOURCES, List.class);
    }

    public void setName(String name) {
        this.attributesEnumMap.put(HelmProperties.NAME, name);
    }

    public void setDescription(String description) {
        this.attributesEnumMap.put(HelmProperties.DESCRIPTION, description);
    }

    public void setVersion(String version) {
        this.attributesEnumMap.put(HelmProperties.VERSION, version);
    }

    public void setIcon(String icon) {
        this.attributesEnumMap.put(HelmProperties.ICON, icon);
    }

    public void setAppVersion(String appVersion) {
        this.attributesEnumMap.put(HelmProperties.APP_VERSION, appVersion);
    }

    public void setEngine(String engine) {
        this.attributesEnumMap.put(HelmProperties.ENGINE, engine);
    }

    public void setKeywords(List<String> keywords) {
        this.attributesEnumMap.put(HelmProperties.KEYWORDS, keywords);
    }

    public void setMaintainers(List<Map<String, String>> maintainers) {
        this.attributesEnumMap.put(HelmProperties.MAINTAINERS, maintainers);
    }

    private <T> T getValue(HelmProperties property, Class<T> tClass) {
        return tClass.cast(this.attributesEnumMap.get((Object)property));
    }
}

