/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.servlet;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;

public class ServletHelper {
    private static final int BUFFER_SIZE = SystemPropertiesHelper.getInteger((String)(String.valueOf(ServletHelper.class.getName()) + ".BUFFER_SIZE"), (int)-1);

    private ServletHelper() {
    }

    public static boolean isDebug(HttpServletRequest request) {
        Preconditions.checkNotNull((Object)request);
        String value = request.getParameter("debug");
        if (value == null) {
            return false;
        }
        if (value.trim().length() == 0) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    public static void addNoCacheResponseHeaders(HttpServletResponse response) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Expires", "0");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void sendContent(InputStream input, HttpServletResponse response) throws IOException {
        int bufferSize = BUFFER_SIZE;
        if (bufferSize < 1) {
            bufferSize = response.getBufferSize();
            if (bufferSize < 1) {
                bufferSize = 8192;
                response.setBufferSize(bufferSize);
            }
        } else {
            response.setBufferSize(bufferSize);
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            InputStream from = input;
            try {
                try (ServletOutputStream to = response.getOutputStream();){
                    int r;
                    byte[] buf = new byte[bufferSize];
                    while ((r = from.read(buf)) != -1) {
                        to.write(buf, 0, r);
                    }
                    response.flushBuffer();
                }
                if (from == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (from == null) throw throwable;
                from.close();
                throw throwable;
            }
            from.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

