/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extender.modules.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.CachedGauge;
import com.codahale.metrics.annotation.Gauge;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.palominolabs.metrics.guice.GaugeInjectionListener;
import com.palominolabs.metrics.guice.MetricNamer;
import com.palominolabs.metrics.guice.annotation.AnnotationResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.extender.modules.internal.CachedGaugeInjectionListener;

public class CachedGaugeTypeListener
implements TypeListener {
    private static final String CACHE_DISABLE_ALL = "nexus.analytics.cache.disableAll";
    private static final String CACHE_DISABLE_PREFIX = "nexus.analytics.cache.disable.";
    private static final String CACHE_TIMEOUT_SUFFIX = ".cache.timeout";
    private static final String CACHE_TIMEUNIT_SUFFIX = ".cache.timeUnit";
    private static final String GAUGE_DISABLE_SUFFIX = ".disable";
    private final Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    private final MetricRegistry metricRegistry;
    private final MetricNamer metricNamer;
    private final AnnotationResolver annotationResolver;
    private final Map<?, ?> nexusProperties;

    public CachedGaugeTypeListener(MetricRegistry metricRegistry, MetricNamer metricNamer, AnnotationResolver annotationResolver, Map<?, ?> nexusProperties) {
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry);
        this.metricNamer = (MetricNamer)Preconditions.checkNotNull((Object)metricNamer);
        this.annotationResolver = (AnnotationResolver)Preconditions.checkNotNull((Object)annotationResolver);
        this.nexusProperties = nexusProperties;
    }

    private Gauge fromCachedGauge(final CachedGauge annotation) {
        return new Gauge(){

            public Class<? extends Annotation> annotationType() {
                return Gauge.class;
            }

            public String name() {
                return annotation.name();
            }

            public boolean absolute() {
                return annotation.absolute();
            }
        };
    }

    public <T> void hear(TypeLiteral<T> typeLiteral, TypeEncounter<T> typeEncounter) {
        Class clazz = typeLiteral.getRawType();
        while (clazz != null) {
            Method[] methodArray = clazz.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                this.processAnnotationMethod(method, typeEncounter);
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
    }

    private <T> void processAnnotationMethod(Method method, TypeEncounter<T> typeEncounter) {
        if (method.isSynthetic()) {
            return;
        }
        CachedGauge annotation = (CachedGauge)this.annotationResolver.findAnnotation(CachedGauge.class, method);
        if (annotation == null) {
            return;
        }
        if (method.getParameterCount() != 0) {
            typeEncounter.addError("Method %s is annotated with @CachedGauge but requires parameters.", new Object[]{method});
            return;
        }
        String metricName = this.metricNamer.getNameForGauge(method, this.fromCachedGauge(annotation));
        if (Boolean.parseBoolean((String)this.nexusProperties.get(String.valueOf(metricName) + GAUGE_DISABLE_SUFFIX))) {
            this.log.info("Removed Analytics for {} as directed in nexus.properties", (Object)metricName);
            return;
        }
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        typeEncounter.register(this.buildInjectionListener(metricName, method, annotation));
    }

    private <T> InjectionListener<T> buildInjectionListener(String metricName, Method method, CachedGauge annotation) {
        if (Boolean.parseBoolean((String)this.nexusProperties.get(CACHE_DISABLE_ALL)) || Boolean.parseBoolean((String)this.nexusProperties.get(CACHE_DISABLE_PREFIX + metricName))) {
            this.log.info("Disabled Analytics Cache for {} as directed in nexus.properties", (Object)metricName);
            return new GaugeInjectionListener(this.metricRegistry, metricName, method);
        }
        long timeout = annotation.timeout();
        Optional<Long> timeoutOverride = this.getTimeoutOverride(metricName);
        if (timeoutOverride.isPresent()) {
            timeout = timeoutOverride.get();
        }
        TimeUnit timeUnit = annotation.timeoutUnit();
        Optional<TimeUnit> timeUnitOverride = this.getTimeUnitOverride(metricName);
        if (timeUnitOverride.isPresent()) {
            timeUnit = timeUnitOverride.get();
        }
        if (timeout != annotation.timeout() || !timeUnit.equals((Object)annotation.timeoutUnit())) {
            this.log.info("Updated Analytics Cache for {} to {} {} as directed in nexus.properties", new Object[]{metricName, timeout, timeUnit});
        }
        return new CachedGaugeInjectionListener(this.metricRegistry, metricName, method, timeout, timeUnit);
    }

    private Optional<Long> getTimeoutOverride(String metricName) {
        block3: {
            if (this.nexusProperties.containsKey(String.valueOf(metricName) + CACHE_TIMEOUT_SUFFIX)) {
                Object value = this.nexusProperties.get(String.valueOf(metricName) + CACHE_TIMEOUT_SUFFIX);
                try {
                    return Optional.of(Long.parseLong(value.toString()));
                }
                catch (Exception ex) {
                    this.log.warn("Failed to parse Analytics Cache configuration in nexus.properties: {} = {}", (Object)(String.valueOf(metricName) + CACHE_TIMEOUT_SUFFIX), value);
                    if (!this.log.isDebugEnabled()) break block3;
                    this.log.debug("Stack Trace:", (Throwable)ex);
                }
            }
        }
        return Optional.empty();
    }

    private Optional<TimeUnit> getTimeUnitOverride(String metricName) {
        block3: {
            if (this.nexusProperties.containsKey(String.valueOf(metricName) + CACHE_TIMEUNIT_SUFFIX)) {
                Object value = this.nexusProperties.get(String.valueOf(metricName) + CACHE_TIMEUNIT_SUFFIX);
                try {
                    return Optional.of(TimeUnit.valueOf(value.toString().toUpperCase()));
                }
                catch (Exception ex) {
                    this.log.warn("Failed to parse Analytics Cache configuration in nexus.properties: {} = {}", (Object)(String.valueOf(metricName) + CACHE_TIMEUNIT_SUFFIX), value);
                    if (!this.log.isDebugEnabled()) break block3;
                    this.log.debug("Stack Trace:", (Throwable)ex);
                }
            }
        }
        return Optional.empty();
    }
}

