/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extender.modules.internal;

import com.codahale.metrics.CachedGauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import com.google.inject.spi.InjectionListener;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public class CachedGaugeInjectionListener<T>
implements InjectionListener<T> {
    private final MetricRegistry metricRegistry;
    private final String metricName;
    private final long timeout;
    private final TimeUnit timeUnit;
    private final Method method;

    public CachedGaugeInjectionListener(MetricRegistry metricRegistry, String metricName, Method method, long timeout, TimeUnit timeUnit) {
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry);
        this.metricName = (String)Preconditions.checkNotNull((Object)metricName);
        this.timeout = timeout;
        this.timeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)timeUnit)));
        this.method = (Method)Preconditions.checkNotNull((Object)method);
    }

    public void afterInjection(final T t) {
        this.metricRegistry.register(this.metricName, (Metric)new CachedGauge<Object>(this.timeout, this.timeUnit){

            protected Object loadValue() {
                try {
                    return CachedGaugeInjectionListener.this.method.invoke(t, new Object[0]);
                }
                catch (Exception e) {
                    return new RuntimeException(e);
                }
            }
        });
    }
}

