/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extender.modules;

import com.google.common.base.Strings;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.shiro.guice.aop.ShiroAopModule;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.launch.BundleModule;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.SpaceModule;
import org.osgi.framework.Bundle;
import org.sonatype.nexus.common.guice.AbstractInterceptorModule;
import org.sonatype.nexus.common.guice.TypeConverterSupport;
import org.sonatype.nexus.extender.modules.DataAccessModule;
import org.sonatype.nexus.extender.modules.FeatureFlaggedIndex;
import org.sonatype.nexus.extender.modules.InstrumentationModule;
import org.sonatype.nexus.extender.modules.JwtSecurityFilterModule;
import org.sonatype.nexus.extender.modules.MetricsRegistryModule;
import org.sonatype.nexus.extender.modules.RankingModule;
import org.sonatype.nexus.extender.modules.SecurityFilterModule;
import org.sonatype.nexus.extender.modules.ServletContextModule;
import org.sonatype.nexus.extender.modules.WebResourcesModule;
import org.sonatype.nexus.validation.ValidationModule;

public class NexusBundleModule
extends BundleModule {
    private static final ShiroAopModule shiroAopModule = new ShiroAopModule();
    private static final SecurityFilterModule securityFilterModule = new SecurityFilterModule();
    private static final JwtSecurityFilterModule jwtSecurityFilterModule = new JwtSecurityFilterModule();
    private static final MetricsRegistryModule metricsRegistryModule = new MetricsRegistryModule();
    private static final ValidationModule validationModule = new ValidationModule();
    private static final WebResourcesModule webResourcesModule = new WebResourcesModule();
    private static final RankingModule rankingModule = new RankingModule();
    private final InstrumentationModule instrumentationModule;
    private final Map<?, ?> nexusProperties;
    private final ServletContextModule servletContextModule;
    private final List<AbstractInterceptorModule> interceptorModules;
    private final List<TypeConverterSupport> converterModules;
    private final String imports;

    public NexusBundleModule(Bundle bundle, MutableBeanLocator locator, Map<?, ?> nexusProperties, ServletContextModule servletContextModule, List<AbstractInterceptorModule> interceptorModules, List<TypeConverterSupport> converterModules) {
        super(bundle, locator);
        this.nexusProperties = nexusProperties;
        this.servletContextModule = servletContextModule;
        this.interceptorModules = interceptorModules;
        this.converterModules = converterModules;
        this.instrumentationModule = new InstrumentationModule(this.nexusProperties);
        this.imports = Strings.nullToEmpty((String)((String)bundle.getHeaders().get("Import-Package")));
    }

    protected List<Module> modules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        this.maybeAddDataAccessBindings(modules);
        this.maybeAddSecurityFilter(modules);
        this.maybeAddServletContext(modules);
        this.maybeAddMetricsRegistry(modules);
        this.maybeAddWebResources(modules);
        this.addInterceptors(modules);
        modules.addAll(super.modules());
        modules.addAll(this.converterModules);
        modules.add((Module)rankingModule);
        return modules;
    }

    protected Map<?, ?> getProperties() {
        return this.nexusProperties;
    }

    protected Module spaceModule() {
        return new SpaceModule((ClassSpace)this.space, FeatureFlaggedIndex.filterByFeatureFlag(this.space.getBundle()));
    }

    private void maybeAddDataAccessBindings(List<Module> modules) {
        if (Boolean.parseBoolean((String)this.nexusProperties.get("nexus.datastore.enabled")) && (this.imports.contains("org.sonatype.nexus.datastore") || this.imports.contains("org.sonatype.nexus.repository.content"))) {
            modules.add((Module)new DataAccessModule(this.space.getBundle()));
        }
    }

    private void maybeAddSecurityFilter(List<Module> modules) {
        if (this.imports.contains("org.sonatype.nexus.security")) {
            if (Boolean.parseBoolean((String)this.nexusProperties.get("nexus.jwt.enabled"))) {
                modules.add((Module)jwtSecurityFilterModule);
            } else {
                modules.add((Module)securityFilterModule);
            }
        }
    }

    private void maybeAddServletContext(List<Module> modules) {
        if (this.imports.contains("com.google.inject.servlet")) {
            modules.add((Module)this.servletContextModule);
        }
    }

    private void maybeAddMetricsRegistry(List<Module> modules) {
        if (this.imports.contains("com.codahale.metrics")) {
            modules.add((Module)metricsRegistryModule);
        }
    }

    private void maybeAddWebResources(List<Module> modules) {
        if (this.space.getBundle().getEntry("static") != null) {
            modules.add((Module)webResourcesModule);
        }
    }

    private void addInterceptors(List<Module> modules) {
        modules.add((Module)shiroAopModule);
        modules.add((Module)this.instrumentationModule);
        modules.add((Module)validationModule);
        modules.addAll(this.interceptorModules);
    }
}

