/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extender.modules;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.eclipse.sisu.space.ClassFinder;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.IndexedClassFinder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;

public class FeatureFlaggedIndex
implements ClassFinder {
    private static final Logger log = LoggerFactory.getLogger(FeatureFlaggedIndex.class);
    private static final String FEATURE_FLAGGED_HEADER = "Feature-Flagged";
    private static final String PACKAGE_INFO = "package-info";
    private static final String NAMED_INDEX = "META-INF/sisu/javax.inject.Named";
    private static final IndexedClassFinder GLOBAL_INDEX = new IndexedClassFinder("META-INF/sisu/javax.inject.Named", true);
    private static final Predicate<String> ALLOW_EVERYTHING = name -> true;
    private final Predicate<String> allowed;

    public static ClassFinder filterByFeatureFlag(Bundle bundle) {
        String featureFlaggedClasses = FeatureFlaggedIndex.findFeatureFlaggedClasses(bundle);
        if (!Strings.isNullOrEmpty((String)featureFlaggedClasses)) {
            String[] classNames = featureFlaggedClasses.split(",");
            Predicate<String> allowed = ALLOW_EVERYTHING;
            String[] stringArray = classNames;
            int n = classNames.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                int packageInfoIndex = className.indexOf(PACKAGE_INFO);
                if (packageInfoIndex > 0 && FeatureFlaggedIndex.isFeatureFlagDisabled(bundle, className)) {
                    String packageName = className.substring(0, packageInfoIndex);
                    allowed = allowed.and(name -> !name.startsWith(packageName));
                }
                ++n2;
            }
            HashSet<String> disabledComponents = new HashSet<String>();
            String[] stringArray2 = classNames;
            int n3 = classNames.length;
            n = 0;
            while (n < n3) {
                String className = stringArray2[n];
                if (!className.contains(PACKAGE_INFO) && allowed.test(className) && FeatureFlaggedIndex.isFeatureFlagDisabled(bundle, className)) {
                    disabledComponents.add(className);
                }
                ++n;
            }
            if (!disabledComponents.isEmpty()) {
                allowed = allowed.and(name -> !disabledComponents.contains(name));
            }
            if (allowed != ALLOW_EVERYTHING) {
                return new FeatureFlaggedIndex(allowed);
            }
        }
        return GLOBAL_INDEX;
    }

    @VisibleForTesting
    public static boolean isFeatureFlagDisabled(Bundle bundle, String clazzName) {
        try {
            Class clazz = bundle.loadClass(clazzName);
            boolean flagResult = Arrays.stream((FeatureFlag[])clazz.getAnnotationsByType(FeatureFlag.class)).map(flag -> SystemPropertiesHelper.getBoolean((String)flag.name(), (boolean)flag.enabledByDefault())).reduce(true, (result, flag) -> flag != false && result != false);
            return !flagResult;
        }
        catch (Exception | LinkageError e) {
            log.debug("Cannot determine feature-flag for {}; assuming false", (Object)clazzName, (Object)e);
            return false;
        }
    }

    private FeatureFlaggedIndex(Predicate<String> allowed) {
        this.allowed = (Predicate)Preconditions.checkNotNull(allowed);
    }

    public Enumeration<URL> findClasses(ClassSpace space) {
        return Iterators.asEnumeration(StreamSupport.stream(GLOBAL_INDEX.indexedNames(space).spliterator(), false).filter(this.allowed).map(name -> space.getResource(String.valueOf(name.replace('.', '/')) + ".class")).filter(Objects::nonNull).iterator());
    }

    @Nullable
    private static String findFeatureFlaggedClasses(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List fragmentWires = wiring.getProvidedWires("osgi.wiring.host");
        if (fragmentWires == null || fragmentWires.isEmpty()) {
            return FeatureFlaggedIndex.getFeatureFlaggedHeader(bundle);
        }
        ArrayList<Bundle> hostAndFragments = new ArrayList<Bundle>();
        hostAndFragments.add(bundle);
        fragmentWires.stream().map(BundleWire::getRequirerWiring).map(BundleReference::getBundle).collect(Collectors.toCollection(() -> hostAndFragments));
        return Strings.emptyToNull((String)hostAndFragments.stream().map(FeatureFlaggedIndex::getFeatureFlaggedHeader).filter(Objects::nonNull).collect(Collectors.joining(",")));
    }

    @Nullable
    private static String getFeatureFlaggedHeader(Bundle bundle) {
        return Strings.emptyToNull((String)((String)bundle.getHeaders().get(FEATURE_FLAGGED_HEADER)));
    }
}

