/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extender;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BeanLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.sonatype.goodies.lifecycle.Lifecycle;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.app.ManagedLifecycleManager;

@Singleton
public class NexusLifecycleManager
extends ManagedLifecycleManager {
    private static final ManagedLifecycle.Phase[] PHASES = ManagedLifecycle.Phase.values();
    private final BeanLocator locator;
    private final Bundle systemBundle;
    private final Iterable<? extends BeanEntry<Named, Lifecycle>> lifecycles;
    private final Multimap<ManagedLifecycle.Phase, Lifecycle> components = HashMultimap.create();
    private ListMultimap<ManagedLifecycle.Phase, BeanEntry<Named, Lifecycle>> cachedIndex = ArrayListMultimap.create();
    private volatile ManagedLifecycle.Phase currentPhase = ManagedLifecycle.Phase.OFF;

    @Inject
    public NexusLifecycleManager(BeanLocator locator, @Named(value="system") Bundle systemBundle) {
        this.locator = (BeanLocator)Preconditions.checkNotNull((Object)locator);
        this.systemBundle = (Bundle)Preconditions.checkNotNull((Object)systemBundle);
        this.lifecycles = locator.locate(Key.get(Lifecycle.class, Named.class));
        locator.watch(Key.get(BundleContext.class), (Mediator)new BundleContextMediator(), (Object)this);
    }

    public ManagedLifecycle.Phase getCurrentPhase() {
        return this.currentPhase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void to(ManagedLifecycle.Phase targetPhase) throws Exception {
        if (targetPhase == ManagedLifecycle.Phase.OFF) {
            this.declareShutdown();
        } else if (NexusLifecycleManager.isShuttingDown()) {
            return;
        }
        BeanLocator beanLocator = this.locator;
        synchronized (beanLocator) {
            int target = targetPhase.ordinal();
            int current = this.currentPhase.ordinal();
            if (current < target) {
                this.reindex(targetPhase);
            } else {
                this.reindex(this.currentPhase);
            }
            while (current < target) {
                ManagedLifecycle.Phase nextPhase = PHASES[++current];
                this.log.info("Start {}", (Object)nextPhase);
                boolean propagateNonTaskErrors = !ManagedLifecycle.Phase.TASKS.equals((Object)nextPhase);
                for (BeanEntry entry : this.cachedIndex.get((Object)nextPhase)) {
                    this.startComponent(nextPhase, (Lifecycle)entry.getValue(), propagateNonTaskErrors);
                }
                this.currentPhase = nextPhase;
            }
            while (current > target) {
                ManagedLifecycle.Phase prevPhase = PHASES[--current];
                this.log.info("Stop {}", (Object)this.currentPhase);
                for (BeanEntry entry : Lists.reverse((List)this.cachedIndex.get((Object)this.currentPhase))) {
                    this.stopComponent(this.currentPhase, (Lifecycle)entry.getValue(), false);
                }
                this.currentPhase = prevPhase;
            }
        }
        if (this.currentPhase == ManagedLifecycle.Phase.OFF) {
            this.systemBundle.stop();
        }
    }

    public void bounce(ManagedLifecycle.Phase bouncePhase) throws Exception {
        ManagedLifecycle.Phase targetPhase = this.currentPhase;
        if (bouncePhase.ordinal() <= targetPhase.ordinal()) {
            if (bouncePhase == ManagedLifecycle.Phase.KERNEL) {
                System.setProperty("karaf.restart", "true");
            }
            this.to(ManagedLifecycle.Phase.values()[Math.max(0, bouncePhase.ordinal() - 1)]);
        } else {
            targetPhase = bouncePhase;
        }
        this.to(targetPhase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws Exception {
        BeanLocator beanLocator = this.locator;
        synchronized (beanLocator) {
            this.reindex(this.currentPhase);
        }
    }

    private void reindex(ManagedLifecycle.Phase targetPhase) throws Exception {
        ManagedLifecycle.Phase phase;
        ListMultimap<ManagedLifecycle.Phase, BeanEntry<Named, Lifecycle>> index = this.index(targetPhase);
        if (index.equals(this.cachedIndex)) {
            return;
        }
        int p = 1;
        while (p <= this.currentPhase.ordinal()) {
            phase = PHASES[p];
            for (BeanEntry entry : index.get((Object)phase)) {
                if (this.cachedIndex.remove((Object)phase, (Object)entry)) continue;
                this.startComponent(phase, (Lifecycle)entry.getValue(), false);
            }
            ++p;
        }
        if (!this.cachedIndex.isEmpty()) {
            p = this.currentPhase.ordinal();
            while (p >= 1) {
                phase = PHASES[p];
                for (BeanEntry entry : Lists.reverse((List)this.cachedIndex.get((Object)phase))) {
                    this.stopComponent(phase, (Lifecycle)entry.getValue(), false);
                }
                --p;
            }
        }
        this.cachedIndex = index;
    }

    private void startComponent(ManagedLifecycle.Phase phase, Lifecycle lifecycle, boolean propagateErrors) throws Exception {
        try {
            if (this.components.put((Object)phase, (Object)lifecycle)) {
                this.log.debug("Start {}: {}", (Object)phase, (Object)lifecycle);
                lifecycle.start();
            }
        }
        catch (Exception | LinkageError e) {
            if (propagateErrors) {
                throw e;
            }
            this.log.warn("Problem starting {}: {}", new Object[]{phase, lifecycle, e});
        }
    }

    private void stopComponent(ManagedLifecycle.Phase phase, Lifecycle lifecycle, boolean propagateErrors) throws Exception {
        try {
            if (this.components.remove((Object)phase, (Object)lifecycle)) {
                this.log.debug("Stop {}: {}", (Object)phase, (Object)lifecycle);
                lifecycle.stop();
            }
        }
        catch (Exception | LinkageError e) {
            if (propagateErrors) {
                throw e;
            }
            this.log.warn("Problem stopping {}: {}", new Object[]{phase, lifecycle, e});
        }
    }

    private ListMultimap<ManagedLifecycle.Phase, BeanEntry<Named, Lifecycle>> index(ManagedLifecycle.Phase targetPhase) {
        ArrayListMultimap index = ArrayListMultimap.create();
        int target = targetPhase.ordinal();
        for (BeanEntry<Named, Lifecycle> beanEntry : this.lifecycles) {
            ManagedLifecycle managedLifecycle = beanEntry.getImplementationClass().getAnnotation(ManagedLifecycle.class);
            if (managedLifecycle == null || managedLifecycle.phase().ordinal() > target) continue;
            index.put((Object)managedLifecycle.phase(), beanEntry);
        }
        return index;
    }

    private static class BundleContextMediator
    implements Mediator<Annotation, BundleContext, NexusLifecycleManager> {
        private BundleContextMediator() {
        }

        public void add(BeanEntry<Annotation, BundleContext> entry, NexusLifecycleManager manager) throws Exception {
            manager.sync();
        }

        public void remove(BeanEntry<Annotation, BundleContext> entry, NexusLifecycleManager manager) throws Exception {
            manager.sync();
        }
    }
}

