/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.api.metrics;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.sonatype.nexus.blobstore.api.OperationMetrics;
import org.sonatype.nexus.blobstore.api.OperationType;

public class DatastoreBlobStoreMetricsContainer {
    public final AtomicLong blobstoreUsageDelta = new AtomicLong(0L);
    public final AtomicLong blobCountDelta = new AtomicLong(0L);
    public final Map<OperationType, OperationMetrics> operationMetricsDelta = new EnumMap<OperationType, OperationMetrics>(OperationType.class);

    public DatastoreBlobStoreMetricsContainer() {
        this.operationMetricsDelta.put(OperationType.UPLOAD, new OperationMetrics());
        this.operationMetricsDelta.put(OperationType.DOWNLOAD, new OperationMetrics());
    }

    public boolean metricsNeedFlushing() {
        if (this.blobCountDelta.get() != 0L || this.blobstoreUsageDelta.get() != 0L) {
            return true;
        }
        return this.operationMetricsDelta.values().stream().anyMatch(operationMetrics -> operationMetrics.getBlobSize() > 0L || operationMetrics.getErrorRequests() > 0L || operationMetrics.getSuccessfulRequests() > 0L || operationMetrics.getTimeOnRequests() > 0L);
    }

    public Map<OperationType, OperationMetrics> getOperationMetricsDelta() {
        return this.operationMetricsDelta;
    }

    public void recordAddition(long size) {
        this.blobstoreUsageDelta.getAndAdd(size);
        this.blobCountDelta.incrementAndGet();
    }

    public void recordDeletion(long size) {
        this.blobstoreUsageDelta.getAndAdd(-size);
        this.blobCountDelta.decrementAndGet();
    }
}

