/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonatype.goodies.lifecycle.Lifecycle;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobSession;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.blobstore.api.BlobStoreUsageChecker;
import org.sonatype.nexus.blobstore.api.OperationMetrics;
import org.sonatype.nexus.blobstore.api.OperationType;
import org.sonatype.nexus.blobstore.api.RawObjectAccess;
import org.sonatype.nexus.transaction.TransactionalStore;

public interface BlobStore
extends TransactionalStore<BlobSession<?>>,
Lifecycle {
    public static final String BLOB_FILE_CONTENT_SUFFIX = ".bytes";
    public static final String BLOB_FILE_ATTRIBUTES_SUFFIX = ".properties";
    public static final String BLOB_NAME_HEADER = "BlobStore.blob-name";
    public static final String CONTENT_TYPE_HEADER = "BlobStore.content-type";
    public static final String CREATED_BY_HEADER = "BlobStore.created-by";
    public static final String CREATED_BY_IP_HEADER = "BlobStore.created-by-ip";
    public static final String TEMPORARY_BLOB_HEADER = "BlobStore.temporary-blob";
    public static final String DIRECT_PATH_BLOB_HEADER = "BlobStore.direct-path";
    public static final String REPO_NAME_HEADER = "Bucket.repo-name";

    public Blob create(InputStream var1, Map<String, String> var2);

    public Blob create(InputStream var1, Map<String, String> var2, @Nullable BlobId var3);

    public Blob create(Path var1, Map<String, String> var2, long var3, HashCode var5);

    public Blob copy(BlobId var1, Map<String, String> var2);

    default public Blob makeBlobPermanent(BlobId blobId, Map<String, String> headers) {
        return this.copy(blobId, headers);
    }

    @Nullable
    public Blob get(BlobId var1);

    @Nullable
    public Blob get(BlobId var1, boolean var2);

    public boolean exists(BlobId var1);

    public boolean delete(BlobId var1, String var2);

    public boolean deleteHard(BlobId var1);

    public BlobStoreMetrics getMetrics();

    public Map<OperationType, OperationMetrics> getOperationMetricsByType();

    public Map<OperationType, OperationMetrics> getOperationMetricsDelta();

    public void clearOperationMetrics();

    public void compact();

    public void compact(@Nullable BlobStoreUsageChecker var1);

    public BlobStoreConfiguration getBlobStoreConfiguration();

    public void init(BlobStoreConfiguration var1) throws Exception;

    public void remove();

    public Stream<BlobId> getBlobIdStream();

    public Stream<BlobId> getBlobIdUpdatedSinceStream(int var1);

    public Stream<BlobId> getDirectPathBlobIdStream(String var1);

    public BlobAttributes getBlobAttributes(BlobId var1);

    public void setBlobAttributes(BlobId var1, BlobAttributes var2);

    public boolean undelete(@Nullable BlobStoreUsageChecker var1, BlobId var2, BlobAttributes var3, boolean var4);

    public boolean isStorageAvailable();

    default public boolean isGroupable() {
        return true;
    }

    default public boolean isWritable() {
        return this.getBlobStoreConfiguration().isWritable();
    }

    public boolean isStarted();

    public boolean isEmpty();

    public void shutdown() throws Exception;

    default public Future<Boolean> asyncDelete(BlobId blobId) {
        return CompletableFuture.completedFuture(this.deleteHard(blobId));
    }

    default public boolean deleteIfTemp(BlobId blobId) {
        return this.deleteHard(blobId);
    }

    default public void validateCanCreateAndUpdate() throws Exception {
    }

    @VisibleForTesting
    default public void flushMetrics() throws IOException {
    }

    public RawObjectAccess getRawObjectAccess();
}

