/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.conda.util;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.conda.AssetKind;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

public class CondaPathUtils {
    public static final String RSS_XML = "rss.xml";
    public static final String INDEX_HTML = "index.html";
    public static final String CHANNELDATA_JSON = "channeldata.json";
    public static final String REPODATA_JSON = "repodata.json";
    public static final String REPODATA_JSON_BZ2 = "repodata.json.bz2";
    public static final String REPODATA2_JSON = "repodata2.json";
    public static final String TAR_BZ2_EXT = ".tar.bz2";
    public static final String CONDA_EXT = ".conda";

    private CondaPathUtils() {
    }

    public static TokenMatcher.State matcherState(Context context) {
        return (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
    }

    public static String arch(TokenMatcher.State state) {
        return CondaPathUtils.match(state, "arch");
    }

    public static String name(TokenMatcher.State state) {
        return CondaPathUtils.match(state, "name");
    }

    public static String version(TokenMatcher.State state) {
        return CondaPathUtils.match(state, "version");
    }

    static String path(TokenMatcher.State state) {
        return CondaPathUtils.match(state, "path");
    }

    static String build(TokenMatcher.State state) {
        return CondaPathUtils.match(state, "build");
    }

    private static String format(TokenMatcher.State state) {
        return CondaPathUtils.match(state, "format");
    }

    private static String match(TokenMatcher.State state, String name) {
        Preconditions.checkNotNull((Object)state);
        String result = (String)state.getTokens().get(name);
        Preconditions.checkNotNull((Object)result);
        return result;
    }

    public static String buildAssetPath(TokenMatcher.State matcherState, String assetName) {
        return String.format("%s/%s", CondaPathUtils.path(matcherState), assetName);
    }

    public static String buildArchAssetPath(TokenMatcher.State matcherState, String assetName) {
        return String.format("%s/%s/%s", CondaPathUtils.path(matcherState), CondaPathUtils.arch(matcherState), assetName);
    }

    public static String buildCondaPackagePath(TokenMatcher.State matcherState) {
        return String.format("%s/%s/%s-%s-%s%s", CondaPathUtils.path(matcherState), CondaPathUtils.arch(matcherState), CondaPathUtils.name(matcherState), CondaPathUtils.version(matcherState), CondaPathUtils.build(matcherState), CondaPathUtils.format(matcherState));
    }

    public static String normalizeAssetPath(String path) {
        return StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    public static String buildAssetPath(AssetKind assetKind, TokenMatcher.State matcherState) {
        switch (assetKind) {
            case CHANNEL_INDEX_HTML: {
                return CondaPathUtils.buildAssetPath(matcherState, INDEX_HTML);
            }
            case CHANNEL_DATA_JSON: {
                return CondaPathUtils.buildAssetPath(matcherState, CHANNELDATA_JSON);
            }
            case CHANNEL_RSS_XML: {
                return CondaPathUtils.buildAssetPath(matcherState, RSS_XML);
            }
            case ARCH_INDEX_HTML: {
                return CondaPathUtils.buildArchAssetPath(matcherState, INDEX_HTML);
            }
            case ARCH_REPODATA_JSON: {
                return CondaPathUtils.buildArchAssetPath(matcherState, REPODATA_JSON);
            }
            case ARCH_REPODATA_JSON_BZ2: {
                return CondaPathUtils.buildArchAssetPath(matcherState, REPODATA_JSON_BZ2);
            }
            case ARCH_REPODATA2_JSON: {
                return CondaPathUtils.buildArchAssetPath(matcherState, REPODATA2_JSON);
            }
            case ARCH_TAR_PACKAGE: 
            case ARCH_CONDA_PACKAGE: {
                return CondaPathUtils.buildCondaPackagePath(matcherState);
            }
        }
        throw new IllegalStateException("Received an invalid AssetKind of type: " + assetKind.name());
    }
}

