/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.conda.orient.internal.proxy;

import com.sonatype.nexus.repository.conda.AssetKind;
import com.sonatype.nexus.repository.conda.orient.CondaFacet;
import com.sonatype.nexus.repository.conda.orient.internal.CondaFacetImpl;
import com.sonatype.nexus.repository.conda.util.CondaPathUtils;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Facet.Exposed
public class CondaProxyFacetImpl
extends ProxyFacetSupport {
    @Nullable
    protected Content getCachedContent(Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        TokenMatcher.State matcherState = CondaPathUtils.matcherState(context);
        String assetPath = CondaPathUtils.buildAssetPath(assetKind, matcherState);
        return this.getAsset(assetPath);
    }

    @TransactionalTouchBlob
    protected Content getAsset(String assetPath) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.getCondaFacet().findAsset(tx, tx.findBucket(this.getRepository()), assetPath);
        if (asset == null) {
            return null;
        }
        return this.getCondaFacet().toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        TokenMatcher.State matcherState = CondaPathUtils.matcherState(context);
        if (assetKind == AssetKind.ARCH_TAR_PACKAGE || assetKind == AssetKind.ARCH_CONDA_PACKAGE) {
            return this.putCondaPackage(content, assetKind, matcherState);
        }
        String assetPath = CondaPathUtils.buildAssetPath(assetKind, matcherState);
        return this.putMetadata(content, assetKind, assetPath);
    }

    private Content putCondaPackage(Content content, AssetKind assetKind, TokenMatcher.State matcherState) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content.openInputStream(), CondaFacetImpl.HASH_ALGORITHMS);){
            Component component = this.findOrCreateComponent(CondaPathUtils.arch(matcherState), CondaPathUtils.name(matcherState), CondaPathUtils.version(matcherState));
            return this.findOrCreateAsset(tempBlob, content, assetKind, CondaPathUtils.buildCondaPackagePath(matcherState), component);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Component findOrCreateComponent(String arch, String name, String version) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Component component = this.getCondaFacet().findComponent(tx, this.getRepository(), arch, name, version);
        if (component == null) {
            component = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).group(arch).name(name)).version(version);
        }
        tx.saveComponent(component);
        return component;
    }

    private Content putMetadata(Content content, AssetKind assetKind, String assetPath) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content.openInputStream(), CondaFacetImpl.HASH_ALGORITHMS);){
            return this.findOrCreateAsset(tempBlob, content, assetKind, assetPath, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content findOrCreateAsset(TempBlob tempBlob, Content content, AssetKind assetKind, String assetPath, Component component) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = this.getCondaFacet().findAsset(tx, bucket, assetPath);
        if (asset == null) {
            asset = AssetKind.ARCH_TAR_PACKAGE.equals((Object)assetKind) || AssetKind.ARCH_CONDA_PACKAGE.equals((Object)assetKind) ? tx.createAsset(bucket, component) : tx.createAsset(bucket, this.getRepository().getFormat());
            asset.name(assetPath);
            asset.formatAttributes().set("asset_kind", (Object)assetKind.name());
        }
        return this.getCondaFacet().saveAsset(tx, asset, (InputStreamSupplier)tempBlob, (Payload)content);
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) {
        this.setCacheInfo(content, cacheInfo);
    }

    @TransactionalTouchMetadata
    protected void setCacheInfo(Content content, CacheInfo cacheInfo) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent Conda asset {}", content.getAttributes().require(Asset.class));
            return;
        }
        this.log.debug("Updating cacheInfo of {} to {}", (Object)asset, (Object)cacheInfo);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    protected String getUrl(@Nonnull Context context) {
        return context.getRequest().getPath().substring(1);
    }

    private CondaFacet getCondaFacet() {
        return (CondaFacet)this.getRepository().facet(CondaFacet.class);
    }
}

