/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;

@Named
@Singleton
@Upgrades(model="healthcheck", from="1.0", to="1.1")
@DependsOn(model="config", version="1.5", checkpoint=true)
public class HealthCheckUpgrade_1_1
extends DatabaseUpgradeSupport {
    private static final String C_TRANSACTION = new OClassNameBuilder().prefix("firewall").type("transaction").build();
    private static final String C_TRANSACTION_SEQUENCE = new OClassNameBuilder().prefix("firewall").type("transaction_sequence").build();
    private final Provider<DatabaseInstance> databaseInstance;

    @Inject
    public HealthCheckUpgrade_1_1(@Named(value="config") Provider<DatabaseInstance> databaseInstance) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
    }

    public void apply() throws Exception {
        HealthCheckUpgrade_1_1.withDatabaseAndClass(this.databaseInstance, (String)C_TRANSACTION, this::dropClass);
        HealthCheckUpgrade_1_1.withDatabaseAndClass(this.databaseInstance, (String)C_TRANSACTION_SEQUENCE, this::dropClass);
    }

    private void dropClass(ODatabaseDocumentTx db, OClass type) {
        db.command((OCommandRequest)new OCommandSQL("DROP CLASS " + type.getName())).execute(new Object[0]);
    }
}

