/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.task.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.sonatype.insight.scan.model.io.ScanWriter;
import com.sonatype.insight.scan.model.io.ScanWriterFactory;
import com.sonatype.nexus.plugins.healthcheck.service.RepositoryHealthCheckConfigurationService;
import com.sonatype.nexus.plugins.healthcheck.task.HealthCheckScannerSupport;
import com.sonatype.nexus.plugins.healthcheck.task.orient.OrientHealthCheckProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Priority(value=0x7FFFFFFF)
public class OrientHealthCheckScanner
extends HealthCheckScannerSupport {
    private final Provider<OrientHealthCheckProcessor> rhcProcessorProvider;

    @Inject
    public OrientHealthCheckScanner(RepositoryHealthCheckConfigurationService config, ScanWriterFactory scanWriterFactory, Provider<OrientHealthCheckProcessor> rhcProcessorProvider) {
        super(config, scanWriterFactory);
        this.rhcProcessorProvider = (Provider)Preconditions.checkNotNull(rhcProcessorProvider);
    }

    @Override
    protected void processAssets(Cancelable cancelable, Repository repo, int scanRate, ScanWriter writer) throws Exception {
        OrientHealthCheckProcessor rhcProcessor = (OrientHealthCheckProcessor)((Object)this.rhcProcessorProvider.get());
        rhcProcessor.beforeWalk(repo, scanRate, writer);
        Optional<Object> lastName = Optional.empty();
        ArrayList needsProcessed = new ArrayList(256);
        int resultSize = 1;
        while (resultSize > 0) {
            boolean hasLastName = lastName.isPresent();
            ImmutableMap params = hasLastName ? ImmutableMap.of((Object)"lastName", lastName.get()) : Collections.emptyMap();
            this.log.debug("querying assets by page using name {}", (Object)lastName.orElse("NONE"));
            Transactional.operation.withDb(((StorageFacet)repo.facet(StorageFacet.class)).txSupplier()).call(() -> OrientHealthCheckScanner.lambda$0(needsProcessed, hasLastName, (Map)params, repo));
            for (Asset asset : needsProcessed) {
                this.checkContinuation(cancelable, repo);
                rhcProcessor.processAsset(repo, asset);
            }
            resultSize = needsProcessed.size();
            this.log.trace("page of assets contained {} results", (Object)resultSize);
            if (resultSize <= 0) continue;
            Asset last = (Asset)needsProcessed.get(needsProcessed.size() - 1);
            lastName = Optional.of(last.name());
            this.log.debug("clearing process buffer and setting name to {}", (Object)lastName.orElse("NONE"));
            needsProcessed.clear();
        }
        this.checkContinuation(cancelable, repo);
        rhcProcessor.afterWalk(repo);
    }

    private static /* synthetic */ Object lambda$0(List list, boolean bl, Map map, Repository repository) throws RuntimeException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Iterables.addAll((Collection)list, (Iterable)tx.findAssets(bl ? "name > :lastName" : null, map, (Iterable)ImmutableList.of((Object)repository), String.format("ORDER BY name LIMIT %d", 256)));
        return null;
    }
}

