/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.task.orient;

import com.google.common.hash.HashCode;
import com.sonatype.insight.scan.anon.Anonymizer;
import com.sonatype.insight.scan.client.ClientScanner;
import com.sonatype.nexus.plugins.healthcheck.service.NexusIDService;
import com.sonatype.nexus.plugins.healthcheck.task.HealthCheckProcessorSupport;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.types.ProxyType;

@Named
public class OrientHealthCheckProcessor
extends HealthCheckProcessorSupport {
    private HealthCheckProcessorSupport.HealthCheckItemExtractor<Asset> extractor = new HealthCheckProcessorSupport.HealthCheckItemExtractor<Asset>(HealthCheckAssetImpl::new);

    @Inject
    OrientHealthCheckProcessor(Anonymizer anonymizer, ClientScanner clientScanner, NexusIDService idService, ProxyType proxyType, @Named(value="maven2") Format maven2Format) {
        super(anonymizer, clientScanner, idService, proxyType, maven2Format);
    }

    public void processAsset(Repository repository, Asset asset) throws Exception {
        this.processAsset(repository, () -> this.extractor.extract(asset, repository, this.maven2Format.equals((Object)repository.getFormat())));
    }

    public void setHealthCheckItemExtractor(HealthCheckProcessorSupport.HealthCheckItemExtractor<Asset> extractor) {
        this.extractor = extractor;
    }

    static class HealthCheckAssetImpl
    extends HealthCheckProcessorSupport.HealthCheckAsset<Asset> {
        public HealthCheckAssetImpl(Asset asset) {
            super(asset);
        }

        @Override
        public String getPath() {
            return ((Asset)this.asset).name();
        }

        @Override
        public long getLastAccess() {
            DateTime lastDownloaded = ((Asset)this.asset).lastDownloaded();
            if (lastDownloaded != null) {
                return lastDownloaded.getMillis();
            }
            return 0L;
        }

        @Override
        public String getSha1() {
            HashCode checksum = ((Asset)this.asset).getChecksum(HashAlgorithm.SHA1);
            return checksum == null ? null : checksum.toString();
        }
    }
}

