/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.task.datastore;

import com.google.common.base.Preconditions;
import com.sonatype.insight.scan.model.io.ScanWriter;
import com.sonatype.insight.scan.model.io.ScanWriterFactory;
import com.sonatype.nexus.plugins.healthcheck.service.RepositoryHealthCheckConfigurationService;
import com.sonatype.nexus.plugins.healthcheck.task.HealthCheckScannerSupport;
import com.sonatype.nexus.plugins.healthcheck.task.datastore.HealthCheckProcessor;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.scheduling.Cancelable;

@Named
public class HealthCheckScannerImpl
extends HealthCheckScannerSupport {
    private final Provider<HealthCheckProcessor> rhcProcessorProvider;

    @Inject
    public HealthCheckScannerImpl(RepositoryHealthCheckConfigurationService config, ScanWriterFactory scanWriterFactory, Provider<HealthCheckProcessor> rhcProcessorProvider) {
        super(config, scanWriterFactory);
        this.rhcProcessorProvider = (Provider)Preconditions.checkNotNull(rhcProcessorProvider);
    }

    @Override
    protected void processAssets(Cancelable cancelable, Repository repo, int scanRate, ScanWriter writer) throws Exception {
        HealthCheckProcessor rhcProcessor = (HealthCheckProcessor)((Object)this.rhcProcessorProvider.get());
        rhcProcessor.beforeWalk(repo, scanRate, writer);
        FluentAssets assets = ((ContentFacet)repo.facet(ContentFacet.class)).assets();
        Continuation page = assets.browse(256, null);
        while (!page.isEmpty()) {
            for (FluentAsset asset : page) {
                this.checkContinuation(cancelable, repo);
                rhcProcessor.processAsset(repo, asset);
            }
            this.log.trace("page of assets contained {} results", (Object)page.size());
            page = assets.browse(256, page.nextContinuationToken());
        }
        this.checkContinuation(cancelable, repo);
        rhcProcessor.afterWalk(repo);
    }
}

