/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.task;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.plugins.healthcheck.service.HdsService;
import com.sonatype.nexus.plugins.healthcheck.service.HealthCheckTaskManager;
import com.sonatype.nexus.plugins.healthcheck.service.HttpResult;
import com.sonatype.nexus.plugins.healthcheck.service.RepositoryHealthCheckConfigurationService;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerManager;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerService;
import com.sonatype.nexus.plugins.healthcheck.task.HealthCheckScanner;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogging;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
@TaskLogging(value=TaskLogType.NEXUS_LOG_ONLY)
public class HealthCheckTask
extends TaskSupport
implements Cancelable {
    public static final String REPOSITORY_NAME_KEY = "repositoryName";
    public static final String STATE_KEY = "state";
    public static final String NEXT_UPLOAD_TIME_KEY = "nextUploadTime";
    public static final String NEXT_DOWNLOAD_TIME_KEY = "nextDownloadTime";
    private final AtomicBoolean running;
    private final WebServerManager webServerManager;
    private final HdsService hdsService;
    private final HealthCheckTaskManager taskManager;
    private final RepositoryHealthCheckConfigurationService config;
    private final RepositoryManager repositoryManager;
    private final HealthCheckScanner healthCheckScanner;
    private Date now;
    private WebServerService webServer;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Inject
    public HealthCheckTask(WebServerManager webServerManager, HdsService hdsService, HealthCheckTaskManager taskManager, RepositoryHealthCheckConfigurationService config, RepositoryManager reg, HealthCheckScanner healthCheckScanner) {
        this.webServerManager = (WebServerManager)Preconditions.checkNotNull((Object)webServerManager);
        this.hdsService = (HdsService)Preconditions.checkNotNull((Object)hdsService);
        this.taskManager = (HealthCheckTaskManager)Preconditions.checkNotNull((Object)taskManager);
        this.config = (RepositoryHealthCheckConfigurationService)Preconditions.checkNotNull((Object)config);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)reg);
        this.healthCheckScanner = (HealthCheckScanner)Preconditions.checkNotNull((Object)healthCheckScanner);
        this.running = new AtomicBoolean();
        this.objectMapper.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true);
    }

    protected Void execute() throws Exception {
        if (this.running.compareAndSet(false, true)) {
            try {
                this.now = new Date();
                try {
                    Void void_ = this.doRunSafe();
                    return void_;
                }
                catch (Exception e) {
                    this.simulateOldBehaviour();
                    throw e;
                }
            }
            finally {
                this.running.set(false);
            }
        }
        this.log.debug("Health check for repository {} already running", (Object)this.getRepositoryName());
        return null;
    }

    private Void doRunSafe() throws Exception {
        String repositoryName = this.getRepositoryName();
        Repository repo = this.getRepository(repositoryName);
        if (repo == null) {
            this.log.debug("Stopping task on deleted/unsupported repository {}", (Object)repositoryName);
            this.config.setEnabled(repositoryName, false);
            this.taskManager.stopTask(repositoryName);
            return null;
        }
        this.log.debug("state = {}, next report = {}, next scan = {}", new Object[]{this.getState(), this.getNextDownloadTime(), this.getNextUploadTime()});
        if (this.webServer == null) {
            this.webServer = this.webServerManager.addWebServer(repositoryName);
        }
        this.doDeltaCheck(repositoryName);
        if (State.INIT.equals((Object)this.getState())) {
            if (!this.webServer.bundleExists() && this.getNextDownloadTime() != null && this.getNextDownloadTime().before(this.getNextUploadTime())) {
                this.setState(State.GET_REPORT);
            } else {
                this.setState(State.PUT_SCAN);
            }
        }
        switch (this.getState()) {
            case PUT_SCAN: {
                if (!this.now.before(this.getNextUploadTime())) {
                    if (!this.doUpload(repo, this.healthCheckScanner.doScan(this, repo))) break;
                    this.setState(State.GET_REPORT);
                    break;
                }
                if (this.webServer.bundleExists()) break;
                this.doDownload(repositoryName);
                break;
            }
            case GET_REPORT: {
                if (this.now.before(this.getNextDownloadTime())) break;
                long overdue = this.now.getTime() - this.getNextDownloadTime().getTime();
                if (this.doDownload(repositoryName)) {
                    this.setState(State.PUT_SCAN);
                    String error = this.webServer.getBundleProperties().getProperty("errorMessage", "");
                    if (error.length() > 0) {
                        this.log.warn("Received no health check report for repository {}: {}", (Object)repositoryName, (Object)error);
                        break;
                    }
                    this.log.info("Received health check report for repository {}", (Object)repositoryName);
                    break;
                }
                if (overdue < 900000L) break;
                if (this.now.before(this.getNextUploadTime())) {
                    throw new IOException("Failed to download health check report for repository " + repositoryName + ", " + overdue / 1000L / 60L + " minutes overdue");
                }
                this.setState(State.PUT_SCAN);
                this.log.debug("Received no health check report for repository {}, retrying with another scan", (Object)repositoryName);
                break;
            }
            default: {
                throw new IllegalStateException("illegal task state " + (Object)((Object)this.getState()));
            }
        }
        this.updateSchedule();
        return null;
    }

    private boolean doUpload(Repository repo, File scanFile) throws IOException {
        try (HttpResult result = this.hdsService.uploadScan(repo.getName(), scanFile);){
            if (!result.isSuccess()) {
                throw new IOException("Failed to upload health check scan for repository " + repo.getName() + ", status code " + result.getStatusCode() + " " + result.getStatusText());
            }
            this.updateTimesFromResult(result, true);
        }
        finally {
            scanFile.delete();
        }
        return this.getNextDownloadTime() != null;
    }

    private void doDeltaCheck(String repositoryName) throws IOException {
        try (HttpResult result = this.hdsService.getNextRunDeltas(repositoryName);){
            if (!result.isSuccess()) {
                throw new IOException("Failed to determine health check interval for repository " + repositoryName + ", status code " + result.getStatusCode() + " " + result.getStatusText());
            }
            this.updateTimesFromResult(result, false);
        }
    }

    private void updateTimesFromResult(HttpResult result, boolean expectDownloadTime) throws IOException {
        block6: {
            ObjectNode obj;
            long nowMillis = System.currentTimeMillis();
            this.now = new Date(nowMillis);
            try {
                obj = (ObjectNode)this.objectMapper.readTree(result.getInputStream());
            }
            catch (Exception e) {
                throw new IOException("Invalid response from Sonatype server: " + e.getMessage(), e);
            }
            try {
                Date nextUploadTime = this.getNextDate(nowMillis, obj, "nextScanUpload");
                this.setNextUploadTime(nextUploadTime);
            }
            catch (Exception e) {
                throw new IOException("Invalid response from Sonatype server: " + e.getMessage(), e);
            }
            try {
                Date nextDownloadTime = this.getNextDate(nowMillis, obj, "nextReportDownload");
                this.setNextDownloadTime(nextDownloadTime);
            }
            catch (Exception e) {
                if (!expectDownloadTime) break block6;
                this.setNextDownloadTime(null);
                this.log.warn("Health check scan was uploaded prematurely, retrying later", (Throwable)e);
            }
        }
    }

    private Date getNextDate(long nowMillis, ObjectNode obj, String propertyName) {
        String propertyValue = obj.get(propertyName).asText();
        long propertyValueMillis = (long)Integer.parseInt(propertyValue) * 1000L;
        return new Date(nowMillis + propertyValueMillis);
    }

    private boolean doDownload(String repositoryName) throws IOException {
        try (HttpResult result = this.hdsService.getHealthCheckBundle(repositoryName);){
            if (result.getStatusCode() == 404) {
                return false;
            }
            if (!result.isSuccess()) {
                throw new IOException("Failed to download health check report for repository " + repositoryName + ", status code " + result.getStatusCode() + " " + result.getStatusText());
            }
            this.webServer.extractBundle(result.getInputStream());
        }
        return true;
    }

    private void simulateOldBehaviour() {
        this.log.debug("Rescheduling to retain old behaviour");
        this.taskManager.updateTaskSchedule(this.getRepositoryName(), this.taskManager.createHealthCheckSchedule(new Date(this.now.getTime() + TimeUnit.HOURS.toMillis(1L))), this.getConfiguration(), false);
    }

    private void updateSchedule() {
        Date nextTime;
        CancelableHelper.checkCancellation();
        switch (this.getState()) {
            case GET_REPORT: {
                nextTime = this.getNextDownloadTime();
                break;
            }
            case PUT_SCAN: {
                nextTime = this.getNextUploadTime();
                break;
            }
            default: {
                throw new IllegalStateException("illegal task state " + (Object)((Object)this.getState()));
            }
        }
        long now = System.currentTimeMillis();
        if (nextTime == null) {
            nextTime = new Date(now + 300000L);
        }
        nextTime = new Date(Math.max(nextTime.getTime(), System.currentTimeMillis() + 5000L));
        this.log.debug("state = {}, next run = {}, next report = {}, next scan = {}", new Object[]{this.getState(), nextTime, this.getNextDownloadTime(), this.getNextUploadTime()});
        this.taskManager.updateTaskSchedule(this.getRepositoryName(), this.taskManager.createHealthCheckSchedule(nextTime), this.getConfiguration(), false);
    }

    public String getMessage() {
        return "Health Check Management for Repository " + this.getRepositoryName();
    }

    public String getRepositoryName() {
        return this.getConfiguration().getString(REPOSITORY_NAME_KEY);
    }

    private Repository getRepository(String repositoryName) {
        Repository repo = this.repositoryManager.get(repositoryName);
        if (repo != null && this.taskManager.isSupported(repo)) {
            return repo;
        }
        return null;
    }

    State getState() {
        return State.valueOf(this.getConfiguration().getString(STATE_KEY, State.INIT.name()));
    }

    void setState(State state) {
        this.log.trace("Setting state to: {}", (Object)state);
        this.getConfiguration().setString(STATE_KEY, state.name());
    }

    Date getNextUploadTime() {
        return this.getConfiguration().getDate(NEXT_UPLOAD_TIME_KEY, null);
    }

    void setNextUploadTime(Date nextUploadTime) {
        this.getConfiguration().setDate(NEXT_UPLOAD_TIME_KEY, nextUploadTime);
    }

    Date getNextDownloadTime() {
        return this.getConfiguration().getDate(NEXT_DOWNLOAD_TIME_KEY, null);
    }

    void setNextDownloadTime(Date nextDownloadTime) {
        this.getConfiguration().setDate(NEXT_DOWNLOAD_TIME_KEY, nextDownloadTime);
    }

    public static enum State {
        INIT,
        PUT_SCAN,
        GET_REPORT;

    }
}

