/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.task;

import com.google.common.base.Preconditions;
import com.sonatype.insight.scan.model.io.ScanWriter;
import com.sonatype.insight.scan.model.io.ScanWriterFactory;
import com.sonatype.nexus.plugins.healthcheck.service.RepositoryHealthCheckConfigurationService;
import com.sonatype.nexus.plugins.healthcheck.task.HealthCheckScanner;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.commons.io.FileUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskInterruptedException;

public abstract class HealthCheckScannerSupport
extends ComponentSupport
implements HealthCheckScanner {
    protected static final int LIMIT = 256;
    protected final RepositoryHealthCheckConfigurationService config;
    protected final ScanWriterFactory scanWriterFactory;

    protected HealthCheckScannerSupport(RepositoryHealthCheckConfigurationService config, ScanWriterFactory scanWriterFactory) {
        this.config = (RepositoryHealthCheckConfigurationService)Preconditions.checkNotNull((Object)config);
        this.scanWriterFactory = (ScanWriterFactory)Preconditions.checkNotNull((Object)scanWriterFactory);
    }

    @Override
    public File doScan(Cancelable cancelable, Repository repo) throws Exception {
        long start = System.currentTimeMillis();
        int scanRate = this.config.getScanRate();
        File tmpFile = File.createTempFile("healthcheck", ".xml.gz");
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (ScanWriter writer = this.scanWriterFactory.newWriter(tmpFile);){
                this.checkContinuation(cancelable, repo);
                this.processAssets(cancelable, repo, scanRate, writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.checkContinuation(cancelable, repo);
            File permFile = new File(tmpFile.getParent(), "healthcheck-" + repo.getName() + ".xml.gz");
            this.backupHealthCheckScan(tmpFile, permFile);
        }
        catch (Exception e) {
            Files.deleteIfExists(tmpFile.toPath());
            throw e;
        }
        long time = System.currentTimeMillis() - start;
        this.log.debug("Scanned repository {} in {} ms", (Object)repo.getName(), (Object)time);
        return tmpFile;
    }

    protected abstract void processAssets(Cancelable var1, Repository var2, int var3, ScanWriter var4) throws Exception;

    protected void backupHealthCheckScan(File tmpFile, File permFile) {
        try {
            FileUtils.copyFile((File)tmpFile, (File)permFile);
        }
        catch (IOException e) {
            this.log.warn("Could not backup health check scan to {}", (Object)permFile, (Object)e);
        }
    }

    protected void checkContinuation(Cancelable cancelable, Repository repo) {
        if (cancelable.isCanceled()) {
            throw new TaskInterruptedException(String.format("Scanning of repository %s got cancelled", repo.getName()), true);
        }
        if (!repo.getConfiguration().isOnline()) {
            throw new TaskInterruptedException(String.format("Repository %s is offline", repo.getName()), false);
        }
    }
}

