/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.collate.OCaseInsensitiveCollate;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.sonatype.nexus.plugins.healthcheck.service.internal.orient.OrientConfigProperty;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.DeleteEntityByPropertyAction;

@Named
@Singleton
public class OrientRepositoryHealthCheckConfigurationEntityAdapter
extends IterableEntityAdapter<OrientConfigProperty> {
    private static final String DB_CLASS = new OClassNameBuilder().type("healthcheckconfig").build();
    static final String P_PROPERTY_NAME = "property_name";
    static final String P_PROPERTY_VALUE = "property_value";
    private final DeleteEntityByPropertyAction delete = new DeleteEntityByPropertyAction((EntityAdapter)this, new String[]{"property_name"});
    private static final String I_PROPERTY_NAME = new OIndexNameBuilder().type(DB_CLASS).property("property_name").build();
    private static final String PROPERTY_QUERY = String.format("SELECT FROM %s WHERE %s = ?", DB_CLASS, "property_name");

    public OrientRepositoryHealthCheckConfigurationEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_PROPERTY_NAME, OType.STRING).setCollate((OCollate)new OCaseInsensitiveCollate()).setMandatory(true).setNotNull(true);
        type.createProperty(P_PROPERTY_VALUE, OType.STRING).setCollate((OCollate)new OCaseInsensitiveCollate()).setMandatory(true).setNotNull(false);
        type.createIndex(I_PROPERTY_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_PROPERTY_NAME});
    }

    protected OrientConfigProperty newEntity() {
        return new OrientConfigProperty();
    }

    protected void readFields(ODocument document, OrientConfigProperty entity) throws Exception {
        String propertyName = (String)document.field(P_PROPERTY_NAME, OType.STRING);
        String propertyValue = (String)document.field(P_PROPERTY_VALUE, OType.STRING);
        entity.setName(propertyName);
        entity.setValue(propertyValue);
    }

    protected void writeFields(ODocument document, OrientConfigProperty entity) throws Exception {
        document.field(P_PROPERTY_NAME, (Object)entity.getName());
        document.field(P_PROPERTY_VALUE, (Object)entity.getValue());
    }

    ODocument selectProperty(ODatabaseDocumentTx db, String id) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)id);
        OSQLSynchQuery query = new OSQLSynchQuery(PROPERTY_QUERY);
        List results = (List)db.command((OCommandRequest)query).execute(new Object[]{id});
        if (!results.isEmpty()) {
            return (ODocument)results.get(0);
        }
        return null;
    }

    public boolean delete(ODatabaseDocumentTx db, String id) {
        return this.delete.execute(db, new Object[]{id});
    }
}

