/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service.impl;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.plugins.healthcheck.service.RepositoryHealthCheckConfigurationService;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerManager;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Singleton
public class WebServerManagerImpl
extends ComponentSupport
implements WebServerManager {
    private final Provider<WebServerService> webServerProvider;
    private final RepositoryHealthCheckConfigurationService configService;
    private final ConcurrentMap<String, WebServerService> webServers = new ConcurrentHashMap<String, WebServerService>();

    @Inject
    public WebServerManagerImpl(Provider<WebServerService> webServerProvider, RepositoryHealthCheckConfigurationService configService) {
        this.webServerProvider = (Provider)Preconditions.checkNotNull(webServerProvider);
        this.configService = (RepositoryHealthCheckConfigurationService)Preconditions.checkNotNull((Object)configService);
    }

    @Override
    public WebServerService addWebServer(String repositoryName) {
        WebServerService webServer = (WebServerService)this.webServerProvider.get();
        webServer.initialize(repositoryName);
        WebServerService previous = this.webServers.putIfAbsent(repositoryName, webServer);
        if (previous == null) {
            this.log.debug("Started report server for repository {}", (Object)repositoryName);
        }
        return previous == null ? webServer : previous;
    }

    @Override
    public WebServerService getWebServer(String repositoryName) {
        if (this.webServers.containsKey(repositoryName)) {
            return (WebServerService)this.webServers.get(repositoryName);
        }
        if (this.configService.isEnabled(repositoryName)) {
            this.addWebServer(repositoryName);
            return (WebServerService)this.webServers.get(repositoryName);
        }
        this.log.debug("web server for repository: {} not started, and health check not enabled for repository", (Object)repositoryName);
        return null;
    }

    @Override
    public void removeWebServer(String repositoryName) {
        if (this.webServers.remove(repositoryName) != null) {
            this.log.debug("Stopped report server for repository {}", (Object)repositoryName);
        }
    }
}

