/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.nexus.plugins.healthcheck.service.LicenseService;
import com.sonatype.nexus.plugins.healthcheck.service.RepositoryHealthCheckConfigurationService;
import com.sonatype.nexus.plugins.healthcheck.service.UrlService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.http.client.utils.URIBuilder;

@Named
@Singleton
public class UrlServiceImpl
implements UrlService {
    private final RepositoryHealthCheckConfigurationService config;
    private final Provider<LicenseService> license;
    private final ObjectMapper jsonObjectMapper = new ObjectMapper();

    @Inject
    public UrlServiceImpl(RepositoryHealthCheckConfigurationService config, Provider<LicenseService> license) {
        this.config = (RepositoryHealthCheckConfigurationService)Preconditions.checkNotNull((Object)config);
        this.license = (Provider)Preconditions.checkNotNull(license);
    }

    @Override
    public String getReportUrl(String nexusInstanceId, String repositoryName) {
        return this.buildInsightUrl(this.getTimestampMap(), "/rest/rhc/report/", nexusInstanceId, repositoryName);
    }

    @Override
    public String getScanUrl(String nexusInstanceId, String repositoryName) {
        return this.buildInsightUrl(this.getTimestampMap(), "/rest/rhc/scan/", nexusInstanceId, repositoryName);
    }

    @Override
    public String getMostPopularVersionsUrl(String nexusInstanceId) {
        return this.buildInsightUrl(null, "/rest/rhc/extras/components/popularity/", nexusInstanceId);
    }

    @Override
    public String getByComponentIdentifiersUrl(String nexusInstanceId, boolean alerts) {
        if (alerts && !((LicenseService)this.license.get()).isSearchAlertDataSupported()) {
            alerts = false;
        }
        return this.buildInsightUrl(alerts ? Collections.singletonMap("alerts", "true") : null, "/rest/rhc/extras/components/", nexusInstanceId);
    }

    @Override
    public String getComponentDetailsUrl(String nexusInstanceId, String hash, ComponentIdentifier componentIdentifier) throws IOException {
        Map<String, String> queryParams = Collections.singletonMap("componentIdentifier", this.jsonObjectMapper.writeValueAsString((Object)componentIdentifier));
        return this.buildInsightUrl(queryParams, "/rest/rhc/extras/componentDetails/", nexusInstanceId, hash);
    }

    private String buildInsightUrl(Map<String, String> queryParams, String base, String ... segments) {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.config.getInsightUrl());
            String basePath = Optional.ofNullable(uriBuilder.getPath()).orElse("");
            StringBuilder pathBuilder = new StringBuilder(basePath);
            pathBuilder.append('/').append(base);
            if (segments != null) {
                String[] stringArray = segments;
                int n = segments.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    pathBuilder.append('/').append(segment);
                    ++n2;
                }
            }
            uriBuilder.setPath(pathBuilder.toString());
            if (queryParams != null) {
                for (Map.Entry<String, String> queryParam : queryParams.entrySet()) {
                    uriBuilder.addParameter(queryParam.getKey(), queryParam.getValue());
                }
            }
            return uriBuilder.build().normalize().toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Map<String, String> getTimestampMap() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'_'HH:mm:ss");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        String timestamp = format.format(new Date());
        Map<String, String> result = Collections.singletonMap("timestamp", timestamp);
        return result;
    }
}

