/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.plugins.healthcheck.service.LicenseService;
import com.sonatype.nexus.plugins.healthcheck.service.RepositoryHealthCheckConfiguration;
import com.sonatype.nexus.plugins.healthcheck.service.RepositoryHealthCheckConfigurationService;
import com.sonatype.nexus.plugins.healthcheck.service.impl.RepositoryHealthCheckConfigurationDAO;
import com.sonatype.nexus.plugins.healthcheck.service.impl.RepositoryHealthCheckConfigurationData;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.manager.RepositoryDeletedEvent;
import org.sonatype.nexus.transaction.Transactional;

@FeatureFlag(name="nexus.datastore.enabled")
@Named(value="mybatis")
@Singleton
public class RepositoryHealthCheckConfigurationServiceImpl
extends ConfigStoreSupport<RepositoryHealthCheckConfigurationDAO>
implements RepositoryHealthCheckConfigurationService,
EventAware {
    private final Provider<LicenseService> license;

    @Inject
    public RepositoryHealthCheckConfigurationServiceImpl(DataSessionSupplier sessionSupplier, Provider<LicenseService> license) {
        super(sessionSupplier);
        this.license = (Provider)Preconditions.checkNotNull(license);
    }

    @Override
    @Transactional
    public RepositoryHealthCheckConfiguration load() {
        return ((RepositoryHealthCheckConfigurationDAO)this.dao()).get().orElse(null);
    }

    @Override
    @Transactional
    public void save(RepositoryHealthCheckConfiguration configuration) {
        ((RepositoryHealthCheckConfigurationDAO)this.dao()).set((RepositoryHealthCheckConfigurationData)configuration);
    }

    @Override
    @Transactional
    public boolean isEnabled(String repositoryName) {
        return ((RepositoryHealthCheckConfigurationDAO)this.dao()).get().flatMap(data -> data.repositoryEnabled(repositoryName)).orElse(false);
    }

    @Override
    @Transactional
    public boolean isConfigured(String repositoryName) {
        return ((RepositoryHealthCheckConfigurationDAO)this.dao()).get().flatMap(data -> data.repositoryEnabled(repositoryName)).isPresent();
    }

    @Override
    @Transactional
    public void setEnabled(String repositoryName, boolean enabled) {
        this.mergeConfiguration(data -> data.enableRepository(repositoryName, enabled));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryDeletedEvent event) {
        String repositoryName = event.getRepository().getName();
        this.log.info("Removing healthcheck enabled property for {}", (Object)repositoryName);
        this.doRemoveRepository(repositoryName);
    }

    @Transactional
    protected void doRemoveRepository(String repositoryName) {
        this.mergeConfiguration(data -> data.removeRepository(repositoryName));
    }

    @Override
    @Transactional
    public void resetDefaults() {
        ((RepositoryHealthCheckConfigurationDAO)this.dao()).clear();
    }

    @Override
    @Transactional
    public String getInsightUrl() {
        return ((RepositoryHealthCheckConfigurationDAO)this.dao()).get().flatMap(data -> data.insightUrl()).map(this::removeTrailingSlash).orElse(((LicenseService)this.license.get()).getDefaultInsightUrl());
    }

    @Override
    @Transactional
    public void setInsightUrl(String insightUrl) {
        this.mergeConfiguration(data -> data.setInsightUrl(insightUrl));
    }

    @Override
    @Transactional
    public boolean getUseTrustStore() {
        return ((RepositoryHealthCheckConfigurationDAO)this.dao()).get().flatMap(data -> data.useTrustStore()).orElse(false);
    }

    @Override
    @Transactional
    public void setUseTrustStore(Boolean useTrustStore) {
        this.mergeConfiguration(data -> data.setUseTrustStore(useTrustStore));
    }

    @Override
    @Transactional
    public int getScanRate() {
        return ((RepositoryHealthCheckConfigurationDAO)this.dao()).get().flatMap(data -> data.scanRate()).orElse(100);
    }

    @Override
    @Transactional
    public void setScanRate(int scanRate) {
        this.mergeConfiguration(data -> data.setScanRate(scanRate));
    }

    @Override
    @Transactional
    public int getHttpTimeout() {
        return ((RepositoryHealthCheckConfigurationDAO)this.dao()).get().flatMap(data -> data.httpTimeout()).orElse(-1);
    }

    @Override
    @Transactional
    public void setHttpTimeout(int httpTimeout) {
        this.mergeConfiguration(data -> data.setHttpTimeout(httpTimeout));
    }

    private void mergeConfiguration(Consumer<RepositoryHealthCheckConfigurationData> change) {
        RepositoryHealthCheckConfigurationData data = ((RepositoryHealthCheckConfigurationDAO)this.dao()).get().orElseGet(RepositoryHealthCheckConfigurationData::new);
        change.accept(data);
        ((RepositoryHealthCheckConfigurationDAO)this.dao()).set(data);
    }

    private String removeTrailingSlash(String url) {
        return StringUtils.stripEnd((String)url, (String)"/");
    }
}

