/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.plugins.healthcheck.service.HdsService;
import com.sonatype.nexus.plugins.healthcheck.service.HealthCheckTaskManager;
import com.sonatype.nexus.plugins.healthcheck.service.RepositoryHealthCheckConfigurationService;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerManager;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryEvent;
import org.sonatype.nexus.repository.manager.RepositoryCreatedEvent;
import org.sonatype.nexus.repository.manager.RepositoryDeletedEvent;
import org.sonatype.nexus.repository.manager.RepositoryLoadedEvent;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.VersionPolicy;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Schedule;
import org.sonatype.nexus.thread.NexusExecutorService;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named
@Singleton
public class HealthCheckTaskManagerImpl
extends StateGuardLifecycleSupport
implements HealthCheckTaskManager {
    private final TaskScheduler nexusScheduler;
    private final WebServerManager webServerManager;
    private final HdsService hdsService;
    private final ProxyType proxyType;
    private final Format maven2Format;
    private final RepositoryHealthCheckConfigurationService configService;
    private final RepositoryManager repositoryManager;
    private final Map<String, String> repositoryNameTaskIdMap = Maps.newHashMap();
    private boolean configuredForNewRepositories = false;
    private boolean configuredForExistingRepositories = false;
    private final int maxConcurrentInsightRequests;
    private ExecutorService executor;

    @Inject
    public HealthCheckTaskManagerImpl(TaskScheduler nexusScheduler, WebServerManager webServermanager, HdsService hdsService, EventManager eventManager, RepositoryHealthCheckConfigurationService configService, RepositoryManager repositoryManager, ProxyType proxyType, @Named(value="maven2") Format maven2Format, @Named(value="${nexus.healthcheck.maxConcurrentInsightRequests:-1}") int maxConcurrentInsightRequests) {
        Preconditions.checkArgument((maxConcurrentInsightRequests > 0 ? 1 : 0) != 0, (Object)"nexus.healthcheck.maxConcurrentInsightRequests must be greater than 0");
        this.nexusScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)nexusScheduler);
        this.webServerManager = (WebServerManager)Preconditions.checkNotNull((Object)webServermanager);
        this.hdsService = (HdsService)Preconditions.checkNotNull((Object)hdsService);
        this.configService = (RepositoryHealthCheckConfigurationService)Preconditions.checkNotNull((Object)configService);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.proxyType = (ProxyType)Preconditions.checkNotNull((Object)proxyType);
        this.maven2Format = (Format)Preconditions.checkNotNull((Object)maven2Format);
        this.maxConcurrentInsightRequests = maxConcurrentInsightRequests;
        ((EventManager)Preconditions.checkNotNull((Object)eventManager)).register((Object)this);
    }

    protected void doStart() throws Exception {
        this.executor = NexusExecutorService.forCurrentSubject((ExecutorService)Executors.newFixedThreadPool(this.maxConcurrentInsightRequests, (ThreadFactory)new NexusThreadFactory("healthcheck-tasks", "healthcheck-tasks")));
        this.maybeScheduleTaskForExistingRepositories();
    }

    protected void doStop() throws Exception {
        this.executor.shutdownNow();
        this.executor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Guarded(by={"STARTED"})
    public TaskInfo getTask(String repositoryName) {
        Map<String, String> map = this.repositoryNameTaskIdMap;
        synchronized (map) {
            TaskInfo task = this.getTaskInMem(repositoryName);
            if (task != null) {
                return task;
            }
            List<TaskInfo> taskList = this.getTasks();
            for (TaskInfo taskItem : taskList) {
                if (!repositoryName.equals(taskItem.getConfiguration().getString("repositoryName"))) continue;
                this.repositoryNameTaskIdMap.put(repositoryName, taskItem.getId());
                return taskItem;
            }
            return null;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<TaskInfo> getTasks() {
        return this.nexusScheduler.listsTasks().stream().filter(task -> "healthcheck".equals(task.getConfiguration().getTypeId())).collect(Collectors.toList());
    }

    private TaskInfo getTaskInMem(String repositorName) {
        String taskId = this.repositoryNameTaskIdMap.get(repositorName);
        if (taskId != null) {
            TaskInfo result = this.nexusScheduler.getTaskById(taskId);
            if (result == null) {
                this.repositoryNameTaskIdMap.remove(repositorName);
            }
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Guarded(by={"STARTED"})
    public TaskInfo scheduleTask(String repositoryName) {
        Map<String, String> map = this.repositoryNameTaskIdMap;
        synchronized (map) {
            TaskInfo task = this.getTaskInMem(repositoryName);
            if (task != null) {
                return task;
            }
            task = this.getTask(repositoryName);
            Calendar cal = Calendar.getInstance();
            cal.add(13, 5);
            Date start = cal.getTime();
            Schedule schedule = this.createHealthCheckSchedule(start);
            if (task != null) {
                this.updateTaskSchedule(repositoryName, schedule, null, true);
            } else {
                TaskConfiguration configuration = this.nexusScheduler.createTaskConfigurationInstance("healthcheck");
                configuration.setString("repositoryName", repositoryName);
                configuration.setName("System - Repository Health Check: " + repositoryName);
                task = this.nexusScheduler.scheduleTask(configuration, schedule);
                this.log.debug("Starting task '{}'", (Object)task.getName());
                this.repositoryNameTaskIdMap.put(repositoryName, task.getId());
            }
            this.webServerManager.addWebServer(repositoryName);
            this.log.info("Enabled health check for repository {}", (Object)repositoryName);
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Guarded(by={"STARTED"})
    public void stopTask(String repositoryName) {
        Map<String, String> map = this.repositoryNameTaskIdMap;
        synchronized (map) {
            TaskInfo task = this.getTask(repositoryName);
            if (task != null) {
                this.log.debug("Stopping task '{}'", (Object)task.getName());
                this.repositoryNameTaskIdMap.remove(repositoryName);
                this.executor.submit(() -> {
                    try {
                        this.hdsService.disableScan(repositoryName);
                    }
                    catch (IOException e) {
                        this.log.warn("Unable to unsubscribe health check for repository {}", (Object)repositoryName, (Object)e);
                    }
                });
                task.remove();
                this.webServerManager.removeWebServer(repositoryName);
                this.log.info("Disabled health check for repository {}", (Object)repositoryName);
            }
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public Schedule createHealthCheckSchedule(Date startAt) {
        return this.nexusScheduler.getScheduleFactory().hourly(startAt);
    }

    @Override
    @Guarded(by={"STARTED"})
    public void updateTaskSchedule(String repositoryName, Schedule schedule, TaskConfiguration configuration, boolean reset) {
        TaskInfo task = this.getTask(repositoryName);
        if (task != null) {
            this.updateTaskSchedule(task, schedule, configuration, reset);
        }
    }

    private void updateTaskSchedule(TaskInfo task, Schedule schedule, @Nullable TaskConfiguration configuration, boolean reset) {
        if (reset) {
            this.log.debug("Recreating scheduled task '{}'", (Object)task.getName());
            task.remove();
        }
        this.log.debug("Rescheduling task '{}'", (Object)task.getName());
        this.nexusScheduler.scheduleTask(configuration != null ? configuration : task.getConfiguration(), schedule);
    }

    @Override
    @Guarded(by={"STARTED"})
    public void refreshTaskSchedules() {
        List<TaskInfo> taskList = this.getTasks();
        Date next = new Date(System.currentTimeMillis() + 10000L);
        for (TaskInfo taskItem : taskList) {
            this.updateTaskSchedule(taskItem, this.createHealthCheckSchedule(next), null, true);
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void removeDuplicates() {
        List<TaskInfo> taskList = this.getTasks();
        HashMap tasksByrepositoryName = Maps.newHashMap();
        for (TaskInfo task : taskList) {
            if (tasksByrepositoryName.put(task.getConfiguration().getString("repositoryName"), task) == null) continue;
            this.log.debug("Stopping duplicate task '{}'", (Object)task.getName());
            task.remove();
        }
    }

    @Override
    public void configure(boolean configuredForNewRepositories, boolean configuredForExistingRepositories) {
        this.configuredForNewRepositories = configuredForNewRepositories;
        this.configuredForExistingRepositories = configuredForExistingRepositories;
        this.maybeScheduleTaskForExistingRepositories();
    }

    private void maybeScheduleTaskForExistingRepositories() {
        if (this.isStarted() && this.configuredForExistingRepositories) {
            for (Repository repository : this.repositoryManager.browse()) {
                this.maybeScheduleTask(repository, true);
            }
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean isConfiguredForNewRepositories() {
        return this.configuredForNewRepositories;
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean isSupported(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        if (!this.proxyType.equals((Object)repository.getType())) {
            return false;
        }
        if (this.maven2Format.equals((Object)repository.getFormat())) {
            return VersionPolicy.RELEASE.equals((Object)((MavenFacet)repository.facet(MavenFacet.class)).getVersionPolicy());
        }
        return true;
    }

    @Subscribe
    public void on(RepositoryCreatedEvent evt) {
        this.handle((RepositoryEvent)evt);
    }

    @Subscribe
    public void on(RepositoryLoadedEvent evt) {
        this.handle((RepositoryEvent)evt);
    }

    @Subscribe
    public void on(RepositoryDeletedEvent evt) {
        String repositoryName = evt.getRepository().getName();
        this.stopTask(repositoryName);
    }

    public void handle(RepositoryEvent evt) {
        if (this.configuredForNewRepositories) {
            this.maybeScheduleTask(evt.getRepository(), false);
        }
    }

    private boolean isCandidateRepository(Repository repository, boolean initializing) {
        String repositoryName = repository.getName();
        boolean alreadyConfigured = this.configService.isConfigured(repositoryName);
        boolean inService = repository.getConfiguration().isOnline();
        boolean isSupported = this.isSupported(repository);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Checking repository: {}", (Object)repositoryName);
            this.log.debug(" Is supported repository: {}", (Object)isSupported);
            this.log.debug(" Is initializing: {}", (Object)initializing);
            this.log.debug(" Is configured already: {}", (Object)alreadyConfigured);
            this.log.debug(" Is in service: {}", (Object)inService);
            this.log.debug(" Has existing task: {}", (Object)(this.getTask(repositoryName) != null ? 1 : 0));
        }
        return isSupported && (initializing || !alreadyConfigured) && inService && this.getTask(repositoryName) == null;
    }

    private void maybeScheduleTask(Repository repository, boolean initializing) {
        if (!EventHelper.isReplicating() && this.isCandidateRepository(repository, initializing)) {
            this.scheduleTask(repository.getName());
            this.configService.setEnabled(repository.getName(), true);
        }
    }
}

