/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.rest;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.plugins.healthcheck.rest.RepositoryHealthCheckApiResourceDoc;
import com.sonatype.nexus.plugins.healthcheck.service.EulaService;
import com.sonatype.nexus.plugins.healthcheck.service.HealthCheckTaskManager;
import com.sonatype.nexus.plugins.healthcheck.service.RepositoryHealthCheckConfigurationService;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;

public abstract class RepositoryHealthCheckApiResource
implements Resource,
RepositoryHealthCheckApiResourceDoc {
    private final HealthCheckTaskManager healthCheckTaskManager;
    private final RepositoryHealthCheckConfigurationService configService;
    private final EulaService eulaService;
    private final RepositoryManager repositoryManager;

    @Inject
    public RepositoryHealthCheckApiResource(HealthCheckTaskManager healthCheckTaskManager, RepositoryHealthCheckConfigurationService configService, EulaService eulaService, RepositoryManager repositoryManager) {
        this.healthCheckTaskManager = (HealthCheckTaskManager)Preconditions.checkNotNull((Object)healthCheckTaskManager);
        this.configService = (RepositoryHealthCheckConfigurationService)Preconditions.checkNotNull((Object)configService);
        this.eulaService = (EulaService)Preconditions.checkNotNull((Object)eulaService);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    @Override
    @POST
    @Path(value="/{repositoryName}/health-check")
    @RequiresPermissions(value={"nexus:healthcheck:update"})
    @RequiresAuthentication
    public void enableRepositoryHealthCheck(@PathParam(value="repositoryName") String repositoryName) {
        Repository repository = this.repositoryManager.get(repositoryName);
        this.ensureRepositoryExists(repository);
        this.ensureProxyRepository(repository);
        this.ensureEulaIsAccepted();
        this.configService.setEnabled(repositoryName, Boolean.TRUE);
        this.healthCheckTaskManager.scheduleTask(repositoryName);
    }

    @Override
    @DELETE
    @Path(value="/{repositoryName}/health-check")
    @RequiresPermissions(value={"nexus:healthcheck:update"})
    @RequiresAuthentication
    public void disableRepositoryHealthCheck(@PathParam(value="repositoryName") String repositoryName) {
        Repository repository = this.repositoryManager.get(repositoryName);
        this.ensureRepositoryExists(repository);
        this.ensureProxyRepository(repository);
        this.configService.setEnabled(repositoryName, Boolean.FALSE);
        this.healthCheckTaskManager.stopTask(repositoryName);
    }

    private void ensureRepositoryExists(Repository repository) {
        if (repository == null) {
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)"\"Repository not found\"", "application/json");
        }
    }

    private void ensureProxyRepository(Repository repository) {
        if (!repository.getType().getValue().equals("proxy")) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)"\"Repository type is not proxy\"", "application/json");
        }
    }

    private void ensureEulaIsAccepted() {
        if (!this.eulaService.isEulaAccepted()) {
            throw new WebApplicationMessageException(Response.Status.CONFLICT, (Object)"\"EULA is not accepted\"", "application/json");
        }
    }
}

