/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.rest;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.plugins.healthcheck.rest.RestUrlBuilder;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerManager;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerService;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public abstract class AbstractHealthCheckWebContentResource {
    public static final String CURRENT_REPORT = "current";
    private final WebServerManager webServerManager;

    public AbstractHealthCheckWebContentResource(WebServerManager webServerManager) {
        this.webServerManager = (WebServerManager)Preconditions.checkNotNull((Object)webServerManager);
    }

    protected Response doGet(String uri, String repositoryName, String path, HttpServletRequest request, HttpServletResponse response) {
        block6: {
            this.preGet(request);
            response.addHeader("X-Frame-Options", "SAMEORIGIN");
            response.setHeader("X-XSS-Protection", "1; mode=block");
            try {
                String redirectPath = this.getRedirectPath(uri, path, repositoryName);
                if (redirectPath == null) break block6;
                response.sendRedirect(redirectPath);
                return null;
            }
            catch (IOException iOException) {
                throw new WebApplicationException("Unable to process requested content.", Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        if (path == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        path = path.substring(path.indexOf("/") + 1);
        WebServerService webServer = this.webServerManager.getWebServer(repositoryName);
        if (webServer == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        WebServerService.ContentItem content = webServer.getContentItem(String.valueOf(this.getBaseDirectory()) + "/" + path);
        if (content == null || !content.exists()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return Response.ok((Object)content.getBlob().getInputStream(), (String)content.getMediaType()).expires(new Date(System.currentTimeMillis() + 29030400L)).lastModified(new Date(content.getLastModified())).build();
    }

    protected boolean preGet(HttpServletRequest request) {
        return true;
    }

    private String getRedirectPath(String uri, String path, String repositoryName) {
        if (!path.startsWith("current/")) {
            return null;
        }
        String timestamp = "unknown";
        WebServerService webService = this.webServerManager.getWebServer(repositoryName);
        if (webService != null) {
            Properties reportProps = webService.getBundleProperties();
            timestamp = reportProps.getProperty("timestamp", timestamp);
        }
        return new RestUrlBuilder().buildUrl(uri, repositoryName, path, timestamp);
    }

    protected abstract String getBaseDirectory();
}

