/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.sonatype.nexus.clm.vulnerability.api.ComponentVulnerabilityApi;
import com.sonatype.nexus.clm.vulnerability.model.ComponentVulnerability;
import com.sonatype.nexus.clm.vulnerability.model.SecurityIssue;
import com.sonatype.nexus.clm.vulnerability.model.ViolationError;
import com.sonatype.nexus.clm.vulnerability.model.evaluation.EvaluationReport;
import com.sonatype.nexus.clm.vulnerability.service.ClmService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.vulnerability.exceptions.CompatibilityException;
import org.sonatype.nexus.repository.vulnerability.exceptions.VulnerabilityFetchingException;
import org.sonatype.nexus.thread.NexusExecutorService;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class ComponentVulnerabilityService
extends StateGuardLifecycleSupport {
    private final ComponentVulnerabilityApi vulnerabilitiesApi;
    private final int maxConcurrentRequests;
    private ExecutorService executor;

    @Inject
    public ComponentVulnerabilityService(@Named(value="${nexus.clm.maxConcurrentRequests:-10}") int maxConcurrentRequests, ComponentVulnerabilityApi vulnerabilitiesApi) {
        Preconditions.checkArgument((maxConcurrentRequests > 0 ? 1 : 0) != 0, (Object)"nexus.clm.maxConcurrentRequests must be greater than 0");
        this.maxConcurrentRequests = maxConcurrentRequests;
        this.vulnerabilitiesApi = vulnerabilitiesApi;
    }

    protected void doStart() {
        this.executor = NexusExecutorService.forCurrentSubject((ExecutorService)Executors.newFixedThreadPool(this.maxConcurrentRequests, (ThreadFactory)new NexusThreadFactory("clm-vulnerability-tasks", "clm-tasks")));
    }

    protected void doStop() throws InterruptedException {
        this.executor.shutdown();
        if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
            this.log.warn("Failed to terminate thread pool in allotted time");
        }
        this.executor = null;
    }

    public List<ComponentVulnerability> getVulnerabilities(ClmService clmService, EvaluationReport evaluationReport) throws VulnerabilityFetchingException, CompatibilityException {
        Set<SecurityIssue> securityIssues = this.getSecurityIssues(evaluationReport);
        ArrayList tasks = new ArrayList();
        securityIssues.forEach(issue -> {
            boolean bl = tasks.add(() -> this.vulnerabilitiesApi.getVulnerabilityDetails(clmService, issue.getReference()));
        });
        List componentVulnerabilityFutures = tasks.stream().map(this.executor::submit).collect(Collectors.toList());
        Stopwatch sw = Stopwatch.createStarted();
        ArrayList<ComponentVulnerability> vulnerabilities = new ArrayList<ComponentVulnerability>();
        for (Future future : componentVulnerabilityFutures) {
            this.fillComponentVulnerabilities(future, vulnerabilities);
        }
        this.log.debug("Found [{}] vulnerabilities for [{}] security issues with total time [{}]", new Object[]{vulnerabilities.size(), securityIssues.size(), sw.stop()});
        return vulnerabilities;
    }

    private Set<SecurityIssue> getSecurityIssues(EvaluationReport evaluationReport) {
        return evaluationReport.getResults().stream().flatMap(componentEvaluationResult -> componentEvaluationResult.getSecurityIssues().stream()).collect(Collectors.toSet());
    }

    private void fillComponentVulnerabilities(Future<ComponentVulnerability> future, List<ComponentVulnerability> vulnerabilities) throws VulnerabilityFetchingException, CompatibilityException {
        try {
            vulnerabilities.add(future.get());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CompatibilityException) {
                throw new CompatibilityException(e.getCause().getMessage());
            }
            throw new VulnerabilityFetchingException(ViolationError.COMPONENT_VULNERABILITY_ERROR.getMessage());
        }
        catch (InterruptedException e) {
            String errorMsg = "Getting component vulnerabilities from IQ has been interrupted";
            this.log.error(errorMsg);
            throw new RuntimeException(errorMsg, e);
        }
    }
}

