/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.service;

import com.google.common.base.Preconditions;
import com.sonatype.insight.rm.rest.RestClient;
import com.sonatype.insight.rm.rest.RestClientFactory;
import com.sonatype.nexus.clm.ClmConfiguration;
import com.sonatype.nexus.clm.ClmConnector;
import com.sonatype.nexus.clm.vulnerability.api.ApplicationsApi;
import com.sonatype.nexus.clm.vulnerability.model.ViolationError;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.repository.vulnerability.exceptions.AppIdMismatchException;
import org.sonatype.nexus.repository.vulnerability.exceptions.CompatibilityException;
import org.sonatype.nexus.repository.vulnerability.exceptions.VulnerabilityFetchingException;

public class ClmService {
    private static final Logger log = LoggerFactory.getLogger(ClmService.class);
    private static final long RETRY_INTERVAL_MS = 5000L;
    private final ClmConnector clmConnector;
    private final HttpClient httpClient;
    private final String url;

    @Inject
    public ClmService(final @Named(value="${nexus.npm.audit.timeout:-600}") int timeout, ClmConnector clmConnector) {
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0, (Object)"nexus.npm.audit.timeout must be greater than 0");
        this.clmConnector = (ClmConnector)((Object)Preconditions.checkNotNull((Object)((Object)clmConnector)));
        this.httpClient = clmConnector.createHttpClientBuilder().setServiceUnavailableRetryStrategy(new ServiceUnavailableRetryStrategy(){

            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                int statusCode = response.getStatusLine().getStatusCode();
                return statusCode == 404 && (long)executionCount < (long)timeout / 5L;
            }

            public long getRetryInterval() {
                return 5000L;
            }
        }).build();
        this.url = ((ClmConfiguration)((Object)Preconditions.checkNotNull((Object)((Object)clmConnector.getConfiguration())))).getUrl();
    }

    public String getUrl() {
        return this.url;
    }

    public InputStream executePost(String jsonRequest, String endpoint) throws IOException, CompatibilityException {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.url).path(endpoint);
        HttpPost request = new HttpPost(uriBuilder.build(new Object[0]));
        request.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        StringEntity stringEntity = new StringEntity(jsonRequest, ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)stringEntity);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
        HttpEntity entity = response.getEntity();
        int statusCode = response.getStatusLine().getStatusCode();
        if (entity.getContent() == null || statusCode != 200) {
            response.getEntity().getContent().close();
            if (statusCode == 404) {
                throw new CompatibilityException(ViolationError.IQ_SERVER_ENDPOINT_COMPATIBILITY_ERROR.getMessage());
            }
            throw new IOException("Bad response from " + endpoint);
        }
        return entity.getContent();
    }

    public InputStream executeGet(String endpoint) throws IOException, CompatibilityException {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.url).path(endpoint);
        HttpGet request = new HttpGet(uriBuilder.build(new Object[0]));
        request.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
        HttpEntity entity = response.getEntity();
        int statusCode = response.getStatusLine().getStatusCode();
        if (entity.getContent() == null || statusCode != 200) {
            response.getEntity().getContent().close();
            if (statusCode == 404) {
                throw new CompatibilityException(ViolationError.IQ_SERVER_ENDPOINT_COMPATIBILITY_ERROR.getMessage());
            }
            throw new IOException("Bad response from " + endpoint);
        }
        return entity.getContent();
    }

    public String getAppId(String applicationId) throws AppIdMismatchException, VulnerabilityFetchingException, CompatibilityException {
        ApplicationsApi applicationsApi = new ApplicationsApi(this.clmConnector.getRestConfiguration());
        try {
            return applicationsApi.getAppId(applicationId);
        }
        catch (IOException e) {
            if (e instanceof HttpResponseException && ((HttpResponseException)e).getStatusCode() == 404) {
                throw new CompatibilityException(ViolationError.IQ_SERVER_ENDPOINT_COMPATIBILITY_ERROR.getMessage());
            }
            throw new VulnerabilityFetchingException(ViolationError.COMPONENT_APP_ERROR.getMessage());
        }
    }

    public void validateConfiguration() throws CompatibilityException {
        RestClient.Base baseRestClient = new RestClientFactory().forConfiguration(this.clmConnector.getRestConfiguration());
        try {
            baseRestClient.validateConfiguration();
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new CompatibilityException(ViolationError.IQ_SERVER_COMPATIBILITY_ERROR.getMessage());
        }
    }
}

