/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.parser;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sonatype.nexus.clm.vulnerability.model.ComponentVulnerability;
import java.util.ArrayList;

public class ComponentVulnerabilityParser {
    private ComponentVulnerabilityParser() {
    }

    public static ComponentVulnerability parse(String json) {
        JsonElement weakness;
        JsonElement detectionMarkdown;
        ComponentVulnerability vulnerability = new ComponentVulnerability();
        JsonElement rootElement = new JsonParser().parse(json);
        JsonObject rootObject = rootElement.getAsJsonObject();
        String identifier = rootObject.get("identifier").getAsString();
        vulnerability.setReference(identifier);
        JsonElement descriptionElement = rootObject.get("description");
        if (!descriptionElement.isJsonNull()) {
            vulnerability.setDescription(descriptionElement.getAsString());
        }
        if (!(detectionMarkdown = rootObject.get("detectionMarkdown")).isJsonNull()) {
            vulnerability.setDetectionMarkdown(detectionMarkdown.getAsString());
        }
        if (!(weakness = rootObject.get("weakness")).isJsonNull()) {
            JsonArray cweIds = weakness.getAsJsonObject().get("cweIds").getAsJsonArray();
            ArrayList<String> uris = new ArrayList<String>(cweIds.size());
            cweIds.forEach(id -> {
                boolean bl = uris.add(id.getAsJsonObject().get("uri").getAsString());
            });
            vulnerability.setCwes(uris);
        }
        return vulnerability;
    }
}

