/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.model.evaluation;

import com.sonatype.nexus.clm.vulnerability.model.ComponentDetails;
import com.sonatype.nexus.clm.vulnerability.model.SecurityIssue;
import com.sonatype.nexus.clm.vulnerability.model.evaluation.PolicyViolation;
import java.util.List;
import java.util.stream.Collectors;

public class ComponentEvaluationResult {
    private ComponentDetails component;
    private SecurityData securityData;
    private PolicyData policyData;

    public ComponentDetails getComponent() {
        return this.component;
    }

    public List<SecurityIssue> getSecurityIssues() {
        return this.securityData.getSecurityIssues();
    }

    public List<PolicyViolation> getPolicyViolations() {
        return this.policyData.getPolicyViolations();
    }

    public List<SecurityIssue> getVulnerableIssues() {
        return this.getSecurityIssues().stream().filter(SecurityIssue::isVulnerable).collect(Collectors.toList());
    }

    public boolean hasViolations() {
        return !this.getPolicyViolations().isEmpty();
    }

    private static class PolicyData {
        private List<PolicyViolation> policyViolations;

        private PolicyData() {
        }

        public List<PolicyViolation> getPolicyViolations() {
            return this.policyViolations;
        }
    }

    private static class SecurityData {
        private List<SecurityIssue> securityIssues;

        private SecurityData() {
        }

        public List<SecurityIssue> getSecurityIssues() {
            return this.securityIssues;
        }
    }
}

