/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.model;

import java.util.Objects;
import org.sonatype.nexus.repository.vulnerability.SeverityLevel;

public class SecurityIssue {
    private final String reference;
    private final String url;
    private final String threatCategory;

    public SecurityIssue(String reference, String url, String threatCategory) {
        this.reference = reference;
        this.url = url;
        this.threatCategory = threatCategory;
    }

    public String getReference() {
        return this.reference;
    }

    public String getUrl() {
        return this.url;
    }

    public SeverityLevel getThreatCategory() {
        return SeverityLevel.getSeverityLevelByIq((String)this.threatCategory);
    }

    public boolean isVulnerable() {
        return this.getThreatCategory() == SeverityLevel.CRITICAL || this.getThreatCategory() == SeverityLevel.HIGH;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityIssue that = (SecurityIssue)o;
        return Objects.equals(this.reference, that.reference);
    }

    public int hashCode() {
        return Objects.hash(this.reference);
    }
}

