/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.UriBuilder;

public class ComponentVulnerability {
    private String reference;
    private String description;
    private String detectionMarkdown;
    private List<String> cwes;
    private String securityUrl;

    public ComponentVulnerability() {
        this.cwes = new ArrayList<String>();
    }

    private ComponentVulnerability(String description, List<String> cwe, String securityUrl) {
        this.description = description;
        this.cwes = cwe;
        this.securityUrl = securityUrl;
    }

    public String getSecurityUrl() {
        return this.securityUrl;
    }

    public void setSecurityUrl(String securityUrl) {
        this.securityUrl = securityUrl;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDetectionMarkdown() {
        return this.detectionMarkdown;
    }

    public void setDetectionMarkdown(String detectionMarkdown) {
        this.detectionMarkdown = detectionMarkdown;
    }

    public List<String> getCwes() {
        return this.cwes;
    }

    public void setCwes(List<String> cwes) {
        this.cwes = cwes;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentVulnerability that = (ComponentVulnerability)o;
        return Objects.equals(this.reference, that.reference);
    }

    public int hashCode() {
        return Objects.hash(this.reference);
    }

    /* synthetic */ ComponentVulnerability(String string, List list, String string2, ComponentVulnerability componentVulnerability) {
        this(string, list, string2);
    }

    public static class Builder {
        private static final String IQ_PATH = "ui/links/vln/";
        private static final int MAX_NPM_REPORT_LINK_LENGTH = 60;
        private String policyName;
        private String securitySummary;
        private List<String> reasons;
        private ComponentVulnerability componentVulnerability;
        private String securityReference;
        private String iqServerUrl;

        private Builder() {
        }

        public Builder setSecurityReference(String securityReference) {
            this.securityReference = securityReference;
            return this;
        }

        public Builder setIqServerUrl(String iqServerUrl) {
            this.iqServerUrl = iqServerUrl;
            return this;
        }

        public Builder setPolicyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public Builder setSecuritySummary(String securitySummary) {
            this.securitySummary = securitySummary;
            return this;
        }

        public Builder setReasons(List<String> reasons) {
            this.reasons = reasons;
            return this;
        }

        public Builder setComponentVulnerability(ComponentVulnerability componentVulnerability) {
            this.componentVulnerability = componentVulnerability;
            return this;
        }

        public ComponentVulnerability build(boolean isSecurityVulnerability) {
            String securityUrl = this.buildSecurityUrl(isSecurityVulnerability, this.securityReference, this.iqServerUrl);
            if (this.componentVulnerability != null) {
                this.componentVulnerability.setSecurityUrl(securityUrl);
                return this.componentVulnerability;
            }
            String summary = isSecurityVulnerability ? this.securitySummary : this.policyName;
            return new ComponentVulnerability(summary, this.reasons, securityUrl, null);
        }

        private String buildSecurityUrl(boolean isSecurityIssue, String reference, String iqServerUrl) {
            if (!isSecurityIssue) {
                return "";
            }
            String securityUrl = UriBuilder.fromUri((String)iqServerUrl).path(IQ_PATH + reference).build(new Object[0]).toString();
            if (securityUrl.length() > 60) {
                securityUrl = securityUrl.replaceFirst(IQ_PATH, IQ_PATH + System.lineSeparator());
            }
            return securityUrl;
        }
    }
}

