/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.model;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class ComponentDetails {
    private final String packageUrl;
    private final String format;
    private final String name;
    private final String version;

    public ComponentDetails(String packageUrl, String format, String name, String version) {
        this.packageUrl = packageUrl;
        this.format = format;
        this.name = name;
        this.version = version;
    }

    public String getPackageUrl() {
        try {
            return URLDecoder.decode(this.packageUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFormat() {
        return this.format;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentDetails that = (ComponentDetails)o;
        return Objects.equals(this.packageUrl, that.packageUrl) && Objects.equals(this.format, that.format) && Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.packageUrl, this.format, this.name, this.version);
    }
}

