/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.api;

import com.sonatype.nexus.clm.vulnerability.model.ComponentVulnerability;
import com.sonatype.nexus.clm.vulnerability.model.ViolationError;
import com.sonatype.nexus.clm.vulnerability.parser.ComponentVulnerabilityParser;
import com.sonatype.nexus.clm.vulnerability.service.ClmService;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.vulnerability.exceptions.CompatibilityException;
import org.sonatype.nexus.repository.vulnerability.exceptions.VulnerabilityFetchingException;

public class ComponentVulnerabilityApi
extends ComponentSupport {
    private static final String VULNERABILITIES_REST_API = "api/v2/vulnerabilities";

    public ComponentVulnerability getVulnerabilityDetails(ClmService service, String vulnerabilityId) throws VulnerabilityFetchingException, CompatibilityException {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream is = service.executeGet("api/v2/vulnerabilities/" + vulnerabilityId);){
                String json = IOUtils.toString((InputStream)is);
                this.log.trace("IQ Response on component vulnerability details:\n{}", (Object)json);
                return ComponentVulnerabilityParser.parse(json);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new VulnerabilityFetchingException(ViolationError.COMPONENT_VULNERABILITY_ERROR.getMessage());
        }
    }
}

