/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.api;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sonatype.nexus.clm.vulnerability.service.ClmService;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.nexus.repository.vulnerability.exceptions.InternalException;

public class ComponentVersionsApi
extends ComponentSupport {
    private static final String COMPONENT_DETAILS_REST_API = "api/v2/components/versions";
    private static final Type LIST_TYPE = new TypeToken<ArrayList<String>>(){}.getType();
    private static final Gson gson = new GsonBuilder().create();

    public List<String> getComponentVersions(ClmService clmService, PackageUrl packageUrl) throws InternalException {
        String jsonRequest = gson.toJson(this.asComponent(packageUrl));
        this.log.trace("IQ Request for component versions: {}", (Object)jsonRequest);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream is = clmService.executePost(jsonRequest, COMPONENT_DETAILS_REST_API);){
                String json = IOUtils.toString((InputStream)is);
                this.log.trace("IQ Response for component versions: {}", (Object)json);
                return (List)gson.fromJson(json, LIST_TYPE);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.debug("Error getting component versions", (Throwable)e);
            throw new InternalException("Error getting component versions");
        }
    }

    private Map<String, String> asComponent(PackageUrl packageUrl) {
        return ImmutableMap.of((Object)"packageUrl", (Object)packageUrl.toString());
    }
}

