/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.api;

import com.google.gson.Gson;
import com.sonatype.nexus.clm.vulnerability.model.ComponentRemediation;
import com.sonatype.nexus.clm.vulnerability.model.ComponentRequest;
import com.sonatype.nexus.clm.vulnerability.model.ViolationError;
import com.sonatype.nexus.clm.vulnerability.parser.ComponentRemediationParser;
import com.sonatype.nexus.clm.vulnerability.service.ClmService;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.vulnerability.exceptions.CompatibilityException;
import org.sonatype.nexus.repository.vulnerability.exceptions.VulnerabilityFetchingException;

public class ComponentRemediationApi
extends ComponentSupport {
    private static final String REMEDIATION_REST_API = "api/v2/components/remediation/application";
    private final Gson gson = new Gson();

    public ComponentRemediation getComponentRemediation(ClmService service, String packageUrl, String applicationId) throws VulnerabilityFetchingException, CompatibilityException {
        this.log.debug("Getting component remediation for {}", (Object)packageUrl);
        ComponentRemediation remediation = new ComponentRemediation(packageUrl);
        ComponentRequest componentRequest = new ComponentRequest(packageUrl);
        String jsonRequest = this.gson.toJson((Object)componentRequest);
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try (InputStream is = service.executePost(jsonRequest, "api/v2/components/remediation/application/" + applicationId);){
                String json = IOUtils.toString((InputStream)is);
                this.log.trace("IQ Response on component remediation:\n{}", (Object)json);
                String version = ComponentRemediationParser.parse(json);
                remediation.setVersion(version);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new VulnerabilityFetchingException(ViolationError.COMPONENT_REMEDIATION_ERROR.getMessage());
        }
        return remediation;
    }
}

