/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataList;
import com.sonatype.clm.dto.model.policy.ComponentFact;
import com.sonatype.clm.dto.model.policy.ConditionFact;
import com.sonatype.clm.dto.model.policy.PolicyAlert;
import com.sonatype.clm.dto.model.policy.PolicyFact;
import com.sonatype.clm.dto.model.policy.TriggerReference;
import com.sonatype.nexus.clm.vulnerability.model.ComponentRemediation;
import com.sonatype.nexus.clm.vulnerability.model.ComponentVulnerability;
import com.sonatype.nexus.clm.vulnerability.model.SecurityIssue;
import com.sonatype.nexus.clm.vulnerability.model.evaluation.ComponentEvaluationResult;
import com.sonatype.nexus.clm.vulnerability.model.evaluation.ConstraintViolation;
import com.sonatype.nexus.clm.vulnerability.model.evaluation.EvaluationReport;
import com.sonatype.nexus.clm.vulnerability.model.evaluation.PolicyViolation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.repository.vulnerability.AuditComponent;
import org.sonatype.nexus.repository.vulnerability.ComponentsVulnerability;
import org.sonatype.nexus.repository.vulnerability.SeverityLevel;
import org.sonatype.nexus.repository.vulnerability.Vulnerability;

public class VulnerabilityMerger {
    private static final Logger log = LoggerFactory.getLogger(VulnerabilityMerger.class);
    private static final Set<String> SECURITY_TYPES = ImmutableSet.of((Object)"SecurityVulnerabilitySeverity", (Object)"SecurityVulnerabilityStatus");

    public ComponentsVulnerability getComponentsVulnerability(Set<AuditComponent> components, EvaluationReport evaluationReport, List<ComponentVulnerability> componentVulnerabilities, List<ComponentRemediation> remediationVersions, String iqServerUrl) {
        Map evaluationReportMap = evaluationReport.getResults().stream().collect(Collectors.toMap(componentEvaluationResult -> componentEvaluationResult.getComponent().getPackageUrl(), Function.identity()));
        Map referenceToVulnerability = componentVulnerabilities.stream().collect(Collectors.toMap(ComponentVulnerability::getReference, Function.identity()));
        Map packageUrlToRemediation = remediationVersions.stream().collect(Collectors.toMap(ComponentRemediation::getPackageUrl, Function.identity()));
        ComponentsVulnerability componentsVulnerability = new ComponentsVulnerability();
        for (AuditComponent component : components) {
            ComponentRemediation remediation = (ComponentRemediation)packageUrlToRemediation.get(component.getPackageUrl());
            ComponentEvaluationResult componentEvaluationResult2 = (ComponentEvaluationResult)evaluationReportMap.get(component.getPackageUrl());
            if (componentEvaluationResult2 == null) {
                log.warn("Can't get component evaluation results for the {} component", (Object)component);
                continue;
            }
            List<PolicyViolation> policyViolations = componentEvaluationResult2.getPolicyViolations();
            for (PolicyViolation policyViolation : policyViolations) {
                SeverityLevel severity = SeverityLevel.calculateThreatCategory((int)policyViolation.getThreatLevel());
                for (ConstraintViolation constraintViolation : policyViolation.getConstraintViolations()) {
                    Optional<String> securityReferenceOpt = this.getSecurityIssue(constraintViolation, componentEvaluationResult2.getSecurityIssues()).map(SecurityIssue::getReference);
                    boolean isSecurityIssue = securityReferenceOpt.isPresent();
                    ComponentVulnerability componentVulnerability = ComponentVulnerability.newBuilder().setComponentVulnerability(securityReferenceOpt.map(referenceToVulnerability::get).orElse(null)).setPolicyName(policyViolation.getPolicyName()).setReasons(constraintViolation.getReasons()).setSecurityReference(securityReferenceOpt.orElse(null)).setIqServerUrl(iqServerUrl).build(isSecurityIssue);
                    Vulnerability vulnerability = this.buildVulnerability(remediation, componentVulnerability, severity);
                    componentsVulnerability.addVulnerability(component, vulnerability);
                }
            }
        }
        return componentsVulnerability;
    }

    public ComponentsVulnerability getComponentsVulnerability(RepositoryComponentEvaluationDataList evaluationReport, String iqServerUrl) {
        ComponentsVulnerability componentsVulnerability = new ComponentsVulnerability();
        List policyFacts = evaluationReport.componentEvalResults.stream().flatMap(componentEvaluationData -> componentEvaluationData.policyAlerts.stream()).map(PolicyAlert::getTrigger).collect(Collectors.toList());
        for (PolicyFact policyFact : policyFacts) {
            String policyName = policyFact.getPolicyName();
            SeverityLevel severity = SeverityLevel.calculateThreatCategory((int)policyFact.getThreatLevel());
            for (ComponentFact componentFact : policyFact.getComponentFacts()) {
                ComponentIdentifier componentIdentifier = this.getComponentIdentifier(componentFact);
                AuditComponent component = this.createAuditComponent(componentIdentifier);
                componentFact.getConstraintFacts().stream().flatMap(constraintFact -> VulnerabilityMerger.removeDuplicates(constraintFact.getConditionFacts()).stream()).forEach(conditionFact -> {
                    String conditionTypeId = conditionFact.getConditionTypeId();
                    boolean isSecurityIssue = SECURITY_TYPES.contains(conditionTypeId);
                    ComponentVulnerability componentVulnerability = ComponentVulnerability.newBuilder().setSecuritySummary(conditionFact.getSummary()).setPolicyName(policyName).setReasons(Collections.singletonList(conditionFact.getReason())).setSecurityReference(VulnerabilityMerger.getSecurityReferenceValue(conditionFact)).setIqServerUrl(iqServerUrl).build(isSecurityIssue);
                    Vulnerability vulnerability = this.buildVulnerability(null, componentVulnerability, severity);
                    componentsVulnerability.addVulnerability(component, vulnerability);
                });
            }
        }
        return componentsVulnerability;
    }

    private static List<ConditionFact> removeDuplicates(List<ConditionFact> conditionFacts) {
        Comparator<ConditionFact> comparator = Comparator.comparing(VulnerabilityMerger::getSecurityReferenceValue, Comparator.nullsFirst(Comparator.naturalOrder()));
        return conditionFacts.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet(comparator)), ArrayList::new));
    }

    private ComponentIdentifier getComponentIdentifier(ComponentFact componentFact) {
        ComponentIdentifier componentIdentifier = componentFact.getComponentIdentifier();
        if (componentIdentifier == null) {
            String pathname = (String)componentFact.getPathnames().get(0);
            String npmPackageId = pathname.substring(0, pathname.indexOf("/-/"));
            String version = pathname.replaceAll(".*?((?<!\\w)\\d+([.]\\d+)*).tgz", "$1");
            ImmutableMap coordinates = ImmutableMap.of((Object)"packageId", (Object)npmPackageId, (Object)"version", (Object)version);
            componentIdentifier = new ComponentIdentifier("npm", (Map)coordinates);
        }
        return componentIdentifier;
    }

    @Nullable
    private static String getSecurityReferenceValue(ConditionFact conditionFact) {
        return Optional.ofNullable(conditionFact.getReference()).map(TriggerReference::getValue).orElse(null);
    }

    private AuditComponent createAuditComponent(ComponentIdentifier componentIdentifier) {
        return new AuditComponent(null, componentIdentifier.getFormat(), componentIdentifier.get("packageId"), componentIdentifier.get("version"));
    }

    private Optional<SecurityIssue> getSecurityIssue(ConstraintViolation constraintViolation, List<SecurityIssue> securityIssues) {
        return securityIssues.stream().filter(securityIssue -> constraintViolation.getReasons().stream().anyMatch(reason -> reason.contains(securityIssue.getReference()))).findAny();
    }

    private Vulnerability buildVulnerability(ComponentRemediation remediation, ComponentVulnerability vulnerability, SeverityLevel severity) {
        String description = this.getDescription(vulnerability);
        String patchedIn = this.getPatchedIn(remediation);
        String moreInfo = this.getMoreInfo(vulnerability);
        return new Vulnerability(severity, description, patchedIn, moreInfo);
    }

    private String getMoreInfo(ComponentVulnerability vulnerability) {
        return StringUtils.isNotEmpty((String)vulnerability.getSecurityUrl()) ? vulnerability.getSecurityUrl() : this.getCwes(vulnerability);
    }

    private String getDescription(ComponentVulnerability vulnerability) {
        return StringUtils.isNotEmpty((String)vulnerability.getDescription()) ? vulnerability.getDescription() : vulnerability.getDetectionMarkdown();
    }

    private String getCwes(ComponentVulnerability vulnerability) {
        return vulnerability.getCwes().stream().collect(Collectors.joining(System.lineSeparator()));
    }

    private String getPatchedIn(ComponentRemediation remediation) {
        return remediation != null ? remediation.getVersion() : "";
    }
}

