/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.ui;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.clm.dto.model.application.ApplicationSummary;
import com.sonatype.insight.rm.rest.RestClient;
import com.sonatype.insight.rm.rest.RestClientConfiguration;
import com.sonatype.insight.rm.rest.RestClientFactory;
import com.sonatype.nexus.clm.ClmAuthenticationType;
import com.sonatype.nexus.clm.ClmConnector;
import com.sonatype.nexus.clm.api.IqConnectionVerificationXo;
import com.sonatype.nexus.clm.api.IqConnectionXo;
import java.io.IOException;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rapture.PasswordPlaceholder;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.validation.Validate;

@Named
@Singleton
@Path(value="/internal/ui/iq")
public class IqUiResource
extends ComponentSupport
implements Resource {
    static final String RESOURCE_PATH = "/internal/ui/iq";
    private ClmConnector clmConnector;

    @Inject
    public IqUiResource(ClmConnector clmConnector) {
        this.clmConnector = (ClmConnector)((Object)Preconditions.checkNotNull((Object)((Object)clmConnector)));
    }

    @POST
    @Path(value="/verify-connection")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:settings:read"})
    @Validate
    public IqConnectionVerificationXo verifyConnection(@NotNull @Valid IqConnectionXo iqConnection) {
        RestClientConfiguration restConfiguration = ClmAuthenticationType.PKI.equals((Object)ClmAuthenticationType.valueOf(iqConnection.getAuthenticationType())) ? this.clmConnector.getRestConfiguration(iqConnection.getUrl(), iqConnection.isUseTrustStoreForUrl(), iqConnection.getTimeoutSeconds()) : this.clmConnector.getRestConfiguration(iqConnection.getUrl(), iqConnection.isUseTrustStoreForUrl(), iqConnection.getTimeoutSeconds(), iqConnection.getUsername(), this.getPassword(iqConnection));
        RestClient.Base restClient = new RestClientFactory().forConfiguration(restConfiguration);
        try {
            restClient.validateConfiguration();
            String applications = restClient.getApplicationsForApplicationEvaluation().getApplicationSummaries().stream().map(ApplicationSummary::getName).collect(Collectors.joining(", "));
            return new IqConnectionVerificationXo(true, applications);
        }
        catch (IOException e) {
            this.log.debug("Failed to verify connection to  IQ Server", (Throwable)e);
            throw new WebApplicationMessageException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @VisibleForTesting
    String getPassword(IqConnectionXo iqConnection) {
        return PasswordPlaceholder.is((String)iqConnection.getPassword()) ? Objects.requireNonNull(this.clmConnector.getConfiguration()).getPassword() : iqConnection.getPassword();
    }
}

