/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.proprietary;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.clm.ClmConnector;
import com.sonatype.nexus.clm.internal.capability.ClmCapability;
import java.util.Date;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityEvent;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.RepositoryCreatedEvent;
import org.sonatype.nexus.repository.manager.RepositoryDeletedEvent;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
public class FirewallProprietaryNameTaskManager
extends StateGuardLifecycleSupport
implements EventAware,
EventAware.Asynchronous {
    private static final String PROPERTY_PREFIX = "nexus.firewallProprietaryNameSync.";
    private final boolean enabled;
    private final String cronSchedule;
    private final TaskScheduler taskScheduler;
    private final ClmConnector clmConnector;

    @Inject
    public FirewallProprietaryNameTaskManager(@Named(value="${nexus.firewall.proprietary.names.enabled:-true}") boolean enabled, @Named(value="${nexus.firewall.proprietary.names.frequency:-2}") int hourFrequency, TaskScheduler taskScheduler, ClmConnector clmConnector) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.clmConnector = (ClmConnector)((Object)Preconditions.checkNotNull((Object)((Object)clmConnector)));
        this.cronSchedule = SystemPropertiesHelper.getString((String)"nexus.firewallProprietaryNameSync.cronSchedule", (String)("0 0 */" + hourFrequency + " ? * *"));
        this.enabled = enabled;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryCreatedEvent event) {
        if (this.enabled && this.isStarted()) {
            this.maybeScheduleTask(event.getRepository());
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryUpdatedEvent event) {
        boolean previouslyFlagged = FirewallProprietaryNameTaskManager.isProprietaryFlagged(event.getOldConfiguration());
        if (this.enabled && this.isStarted() && !previouslyFlagged) {
            this.maybeScheduleTask(event.getRepository());
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryDeletedEvent event) {
        this.removeTask(event.getRepository().getName());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(CapabilityEvent.BeforePassivated event) {
        if (this.isStarted() && FirewallProprietaryNameTaskManager.isClmCapability((CapabilityEvent)event)) {
            this.removeTasks();
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(CapabilityEvent.AfterActivated event) {
        if (this.enabled && this.isStarted() && FirewallProprietaryNameTaskManager.isClmCapability((CapabilityEvent)event)) {
            this.removeTasks();
            this.scheduleTask("*");
        }
    }

    protected void doStart() throws Exception {
        this.removeTasks();
        if (this.enabled && this.isClmEnabled()) {
            this.scheduleTask("*");
        }
    }

    private void removeTasks() {
        this.log.debug("Removing tasks");
        TaskInfo task = null;
        while ((task = this.taskScheduler.getTaskByTypeId("firewall.proprietary.name.sync")) != null) {
            task.remove();
        }
    }

    private void removeTask(String repositoryName) {
        TaskInfo task = this.taskScheduler.getTaskByTypeId("firewall.proprietary.name.sync", FirewallProprietaryNameTaskManager.settings(repositoryName));
        if (task != null) {
            this.log.debug("Removing task for repository {}", (Object)repositoryName);
            task.remove();
        }
    }

    private void maybeScheduleTask(Repository repository) {
        if (!this.isClmEnabled()) {
            this.log.debug("CLM not enabled, not creating task for {}", (Object)repository.getName());
            return;
        }
        if (FirewallProprietaryNameTaskManager.isProprietaryFlagged(repository)) {
            this.scheduleTask(repository.getName());
        } else {
            this.removeTask(repository.getName());
        }
    }

    private void scheduleTask(String repositoryName) {
        Map<String, String> settings = FirewallProprietaryNameTaskManager.settings(repositoryName);
        if (this.taskScheduler.getTaskByTypeId("firewall.proprietary.name.sync", settings) == null) {
            TaskConfiguration taskConfiguration = this.taskScheduler.createTaskConfigurationInstance("firewall.proprietary.name.sync");
            taskConfiguration.setName("Synchronize Proprietary Names to IQ Server for repository " + repositoryName);
            taskConfiguration.setString("repositoryName", repositoryName);
            if ("*".equals(repositoryName)) {
                Cron schedule = this.taskScheduler.getScheduleFactory().cron(new Date(), this.cronSchedule);
                this.log.info("Scheduling synchronization of names for {}", (Object)repositoryName);
                this.taskScheduler.scheduleTask(taskConfiguration, (Schedule)schedule);
                this.taskScheduler.findAndSubmit("firewall.proprietary.name.sync", settings);
            } else {
                this.taskScheduler.submit(taskConfiguration);
            }
        }
    }

    @VisibleForTesting
    boolean isClmEnabled() {
        return this.clmConnector.isEnabled() && this.clmConnector.isConfigured();
    }

    public static boolean isProprietaryFlagged(Repository repository) {
        if (!(repository.getType() instanceof HostedType)) {
            return false;
        }
        return FirewallProprietaryNameTaskManager.isProprietaryFlagged(repository.getConfiguration());
    }

    public static boolean isProprietaryFlagged(Configuration repositoryConfiguration) {
        Object proprietary = repositoryConfiguration.attributes("component").get("proprietaryComponents");
        if (proprietary instanceof Boolean) {
            return (Boolean)proprietary;
        }
        if (proprietary instanceof String) {
            return Boolean.valueOf((String)proprietary);
        }
        return false;
    }

    private static boolean isClmCapability(CapabilityEvent event) {
        return event.getReference().capability() instanceof ClmCapability;
    }

    private static Map<String, String> settings(String repositoryName) {
        return ImmutableMap.of((Object)"repositoryName", (Object)repositoryName);
    }
}

