/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.insight.rm.rest.RestClient;
import com.sonatype.nexus.clm.internal.QuarantineStatus;
import com.sonatype.nexus.clm.internal.RepositoryAttributeStorage;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import com.sonatype.nexus.clm.internal.orient.AssetAttributeStorage;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class UnquarantinedComponentsUpdater
extends ComponentSupport {
    @VisibleForTesting
    static final long ONE_HOUR = TimeUnit.HOURS.toMillis(1L);
    private static final int BATCH_SIZE = 100;
    private final RestClientProvider restClientProvider;
    private final RepositoryAttributeStorage repositoryAttributeStorage;
    private final AssetAttributeStorage assetAttributeStorage;
    private final long unquarantineUpdateMillis;
    private static final String CONDA_FORMAT = "conda";

    @Inject
    public UnquarantinedComponentsUpdater(RestClientProvider restClientProvider, RepositoryAttributeStorage repositoryAttributeStorage, AssetAttributeStorage assetAttributeStorage, @Named(value="${nexus.firewall.unquarantineUpdatePeriod:-60s}") Time unquarantineUpdatePeriod) {
        this.restClientProvider = (RestClientProvider)Preconditions.checkNotNull((Object)restClientProvider);
        this.repositoryAttributeStorage = (RepositoryAttributeStorage)Preconditions.checkNotNull((Object)repositoryAttributeStorage);
        this.assetAttributeStorage = (AssetAttributeStorage)((Object)Preconditions.checkNotNull((Object)((Object)assetAttributeStorage)));
        this.unquarantineUpdateMillis = unquarantineUpdatePeriod.toMillis();
    }

    public void requestAndUpdateUnquarantinedComponents(Repository repository) throws IOException {
        Set pathnames;
        Long lastUpdateTimestamp = this.repositoryAttributeStorage.getQuarantineLastUpdateTimestamp(repository.getName());
        long timestamp = System.currentTimeMillis();
        if (lastUpdateTimestamp == null) {
            this.log.debug("Skipped request for latest unquarantined assets: quarantine is not enabled");
            return;
        }
        if (timestamp - lastUpdateTimestamp < this.unquarantineUpdateMillis) {
            this.log.debug("Skipped request for latest unquarantined assets: {}ms since last update", (Object)(timestamp - lastUpdateTimestamp));
            return;
        }
        RestClient.Repository repositoryClient = this.restClientProvider.getRepositoryClient(repository.getName());
        try {
            pathnames = repositoryClient.getUnquarantinedComponents((long)(lastUpdateTimestamp.longValue() - UnquarantinedComponentsUpdater.ONE_HOUR)).pathnames;
        }
        catch (UnsupportedOperationException e) {
            this.log.debug("IQ Server doesn't support unquarantine request: {}", (Object)e.getMessage());
            return;
        }
        TransactionalStoreMetadata.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).run(() -> {
            String assetFormat = repository.getFormat().getValue();
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            int assetCount = 0;
            for (String path : pathnames) {
                Asset asset;
                if (CONDA_FORMAT.equals(assetFormat)) {
                    path = StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
                }
                if ((asset = tx.findAssetWithProperty("name", (Object)path, tx.findBucket(repository))) == null) {
                    this.log.warn("Could not unquarantine stale asset {}:{}", (Object)repository.getName(), (Object)path);
                    continue;
                }
                QuarantineStatus quarantineStatus = this.assetAttributeStorage.getQuarantineStatus(asset);
                if (quarantineStatus == QuarantineStatus.ALLOW) continue;
                this.log.info("Released quarantined asset {}:{}", (Object)repository.getName(), (Object)path);
                this.assetAttributeStorage.setQuarantineStatus(asset, QuarantineStatus.ALLOW, timestamp);
                tx.saveAsset(asset);
                if (++assetCount % 100 != 0) continue;
                tx.commit();
                tx.begin();
            }
        });
        this.repositoryAttributeStorage.setQuarantineLastUpdateTimestamp(repository.getName(), timestamp);
    }
}

