/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.clm.internal.IQErrorManager;
import com.sonatype.nexus.clm.internal.RepositoryAttributeStorage;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.storage.AssetDeletedEvent;

@Named
@Singleton
public class RemovedAssetSender
extends ComponentSupport
implements EventAware,
EventAware.Asynchronous {
    private final RepositoryAttributeStorage repositoryAttributeStorage;
    private final RestClientProvider restClientProvider;
    private final IQErrorManager iqErrorManager;

    @Inject
    public RemovedAssetSender(RepositoryAttributeStorage repositoryAttributeStorage, RestClientProvider restClientProvider, IQErrorManager iqErrorManager) {
        this.repositoryAttributeStorage = (RepositoryAttributeStorage)Preconditions.checkNotNull((Object)repositoryAttributeStorage);
        this.restClientProvider = (RestClientProvider)Preconditions.checkNotNull((Object)restClientProvider);
        this.iqErrorManager = (IQErrorManager)((Object)Preconditions.checkNotNull((Object)((Object)iqErrorManager)));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onDeleteAsset(AssetDeletedEvent assetDeletedEvent) {
        String repositoryName;
        if (assetDeletedEvent.isLocal() && this.repositoryAttributeStorage.isAuditEnabled(repositoryName = assetDeletedEvent.getRepositoryName())) {
            String assetName = assetDeletedEvent.getAsset().name();
            try {
                this.iqErrorManager.reset(repositoryName);
                this.restClientProvider.getRepositoryClient(repositoryName).removeComponent(assetName);
            }
            catch (IOException | RuntimeException e) {
                this.log.warn("Problem notifying IQ server of removed asset {}:{}: {}", new Object[]{repositoryName, assetName, e.getMessage(), this.log.isDebugEnabled() ? e : null});
                this.iqErrorManager.addErrorMessage(repositoryName, e);
            }
        }
    }
}

