/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.sonatype.nexus.clm.internal.FirewallIgnorePatternsStore;
import com.sonatype.nexus.clm.internal.orient.OrientFirewallIgnorePatterns;
import com.sonatype.nexus.clm.internal.orient.OrientFirewallIgnorePatternsEntityAdapter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientFirewallIgnorePatternsStore
extends StateGuardLifecycleSupport
implements FirewallIgnorePatternsStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientFirewallIgnorePatternsEntityAdapter entityAdapter;

    @Inject
    public OrientFirewallIgnorePatternsStore(@Named(value="config") Provider<DatabaseInstance> databaseInstance, OrientFirewallIgnorePatternsEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientFirewallIgnorePatternsEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db, () -> {
                OrientFirewallIgnorePatterns firewallIgnorePatterns = this.entityAdapter.newEntity();
                HashMap<String, List<String>> defaultRegexpsByFormat = new HashMap<String, List<String>>();
                defaultRegexpsByFormat.put("maven2", Arrays.asList(".*\\.sha1", ".*\\.md5", ".*\\.asc", ".*\\.pom", ".*maven-metadata\\.xml", ".*archetype-catalog\\.xml"));
                firewallIgnorePatterns.setRegexpsByFormat(defaultRegexpsByFormat);
                this.entityAdapter.set(db, (Entity)firewallIgnorePatterns);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Nullable
    @Guarded(by={"STARTED"})
    public Map<String, List<String>> load() {
        return (Map)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.get(db).getRegexpsByFormat());
    }

    @Override
    @Guarded(by={"STARTED"})
    public void save(Map<String, List<String>> regexpsByFormat) {
        OrientFirewallIgnorePatterns firewallIgnorePatterns = this.entityAdapter.newEntity();
        firewallIgnorePatterns.setRegexpsByFormat(regexpsByFormat);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            boolean bl = this.entityAdapter.set(db, (Entity)firewallIgnorePatterns);
        });
    }
}

