/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.sonatype.nexus.clm.internal.orient.OrientFirewallIgnorePatterns;
import com.sonatype.nexus.clm.internal.orient.OrientFirewallIgnorePatternsCreatedEvent;
import com.sonatype.nexus.clm.internal.orient.OrientFirewallIgnorePatternsDeletedEvent;
import com.sonatype.nexus.clm.internal.orient.OrientFirewallIgnorePatternsUpdatedEvent;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.SingletonEntityAdapter;

@Named
@Singleton
public class OrientFirewallIgnorePatternsEntityAdapter
extends SingletonEntityAdapter<OrientFirewallIgnorePatterns> {
    private static final String DB_CLASS = new OClassNameBuilder().prefix("firewall").type("ignore_patterns").build();
    @VisibleForTesting
    static final String P_REGEXPS_BY_FORMAT = "regexps_by_format";

    public OrientFirewallIgnorePatternsEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_REGEXPS_BY_FORMAT, OType.EMBEDDEDMAP).setMandatory(true).setNotNull(true);
    }

    protected OrientFirewallIgnorePatterns newEntity() {
        return new OrientFirewallIgnorePatterns();
    }

    protected void readFields(ODocument document, OrientFirewallIgnorePatterns entity) throws Exception {
        entity.setRegexpsByFormat((Map)document.field(P_REGEXPS_BY_FORMAT, OType.EMBEDDEDMAP));
    }

    protected void writeFields(ODocument document, OrientFirewallIgnorePatterns entity) throws Exception {
        document.field(P_REGEXPS_BY_FORMAT, entity.getRegexpsByFormat());
    }

    public OrientFirewallIgnorePatterns get(ODatabaseDocumentTx db) {
        OrientFirewallIgnorePatterns entity = (OrientFirewallIgnorePatterns)super.get(db);
        if (entity == null) {
            entity = this.newEntity();
        }
        return entity;
    }

    public boolean sendEvents() {
        return true;
    }

    @Nullable
    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        Map regexpsByFormat = (Map)document.field(P_REGEXPS_BY_FORMAT, OType.EMBEDDEDMAP);
        this.log.debug("newEvent: eventKind: {}, regexpsByFormat: {}, metadata: {}", new Object[]{eventKind, regexpsByFormat, metadata});
        switch (eventKind) {
            case CREATE: {
                return new OrientFirewallIgnorePatternsCreatedEvent((EntityMetadata)metadata, regexpsByFormat);
            }
            case UPDATE: {
                return new OrientFirewallIgnorePatternsUpdatedEvent((EntityMetadata)metadata, regexpsByFormat);
            }
            case DELETE: {
                return new OrientFirewallIgnorePatternsDeletedEvent((EntityMetadata)metadata);
            }
        }
        return null;
    }
}

