/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationData;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataList;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataRequestList;
import com.sonatype.clm.dto.model.policy.RepositoryPolicyEvaluationSummary;
import com.sonatype.clm.dto.model.repository.QuarantinedComponentReport;
import com.sonatype.nexus.clm.internal.QuarantineStatus;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import com.sonatype.nexus.clm.internal.orient.AssetAttributeStorage;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientEvaluationSender
extends ComponentSupport {
    private final RestClientProvider restClientProvider;
    private final AssetAttributeStorage assetAttributeStorage;

    @Inject
    public OrientEvaluationSender(RestClientProvider restClientProvider, AssetAttributeStorage assetAttributeStorage) {
        this.restClientProvider = (RestClientProvider)Preconditions.checkNotNull((Object)restClientProvider);
        this.assetAttributeStorage = (AssetAttributeStorage)((Object)Preconditions.checkNotNull((Object)((Object)assetAttributeStorage)));
    }

    public void sendAuditRequest(Asset asset, Repository repository, String reason) throws IOException {
        this.sendAuditRequest((List<Asset>)ImmutableList.of((Object)asset), repository, reason);
    }

    public void sendAuditRequest(List<Asset> assets, Repository repository, String reason) throws IOException {
        if (assets.isEmpty()) {
            return;
        }
        RepositoryComponentEvaluationDataRequestList requestList = this.newRequestList(assets, reason);
        this.restClientProvider.getRepositoryClient(repository.getName()).evaluateComponents(requestList);
        long timestamp = System.currentTimeMillis();
        for (Asset asset : assets) {
            HashCode evaluatedHash = asset.getChecksum(HashAlgorithm.SHA1);
            TransactionalStoreMetadata.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).run(() -> {
                StorageTx tx = (StorageTx)UnitOfWork.currentTx();
                Asset storedAsset = tx.findAsset(EntityHelper.id((Entity)asset));
                if (storedAsset != null && Objects.equals(evaluatedHash, storedAsset.getChecksum(HashAlgorithm.SHA1))) {
                    this.assetAttributeStorage.setAuditTimestamp(storedAsset, timestamp);
                    tx.saveAsset(storedAsset);
                } else {
                    this.log.debug("Ignored audit evaluation for stale asset {}:{}", (Object)repository.getName(), (Object)asset.name());
                }
            });
        }
    }

    public QuarantineStatus sendQuarantineRequest(Asset asset, Repository repository, String reason) throws IOException {
        RepositoryComponentEvaluationDataRequestList requestList = this.newRequestList((List<Asset>)ImmutableList.of((Object)asset), reason);
        RepositoryComponentEvaluationDataList resultList = this.restClientProvider.getRepositoryClient(repository.getName()).evaluateComponentWithQuarantine(requestList);
        if (resultList == null || resultList.isEmpty()) {
            return QuarantineStatus.DENY;
        }
        QuarantineStatus quarantineStatus = this.getQuarantineStatus(resultList);
        HashCode evaluatedHash = asset.getChecksum(HashAlgorithm.SHA1);
        long timestamp = System.currentTimeMillis();
        TransactionalStoreMetadata.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).run(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Asset storedAsset = tx.findAsset(EntityHelper.id((Entity)asset));
            if (storedAsset != null && Objects.equals(evaluatedHash, storedAsset.getChecksum(HashAlgorithm.SHA1))) {
                this.assetAttributeStorage.setQuarantineStatus(storedAsset, quarantineStatus, timestamp);
                tx.saveAsset(storedAsset);
            } else {
                this.log.debug("Ignored quarantine evaluation for stale asset {}:{}", (Object)repository.getName(), (Object)asset.name());
            }
        });
        return quarantineStatus;
    }

    @Nullable
    public String getQuarantineReport(Repository repository) {
        try {
            RepositoryPolicyEvaluationSummary summary = this.restClientProvider.getRepositoryClient(repository.getName()).getPolicyEvaluationSummary();
            String serverUrl = this.restClientProvider.getServerUrl();
            return summary.resolveReportUrl(serverUrl);
        }
        catch (IOException e) {
            this.log.warn("Unable to retrieve the link to IQ Repository Results View for {} repository", (Object)repository.getName(), (Object)e);
            return null;
        }
    }

    @Nullable
    public String getQuarantinedComponentReport(Repository repository, Asset asset) {
        try {
            QuarantinedComponentReport quarantinedComponentReport = this.restClientProvider.getRepositoryClient(repository.getName()).getQuarantinedComponentReport(asset.name());
            String serverUrl = this.restClientProvider.getServerUrl();
            return quarantinedComponentReport.resolveReportUrl(serverUrl);
        }
        catch (IOException e) {
            this.log.warn("Unable to retrieve the link to IQ Quarantined Component View for asset {}:{}", new Object[]{repository.getName(), asset.name(), e});
            return null;
        }
    }

    private RepositoryComponentEvaluationDataRequestList newRequestList(List<Asset> assets, String cause) {
        RepositoryComponentEvaluationDataRequestList requestList = new RepositoryComponentEvaluationDataRequestList(cause);
        for (Asset asset : assets) {
            requestList.components.add(this.newRequest(asset));
        }
        return requestList;
    }

    private RepositoryComponentEvaluationDataRequestList.RepositoryComponentEvaluationDataRequest newRequest(Asset asset) {
        String hash = asset.getChecksum(HashAlgorithm.SHA1).toString();
        return new RepositoryComponentEvaluationDataRequestList.RepositoryComponentEvaluationDataRequest(asset.format(), asset.name(), hash);
    }

    private QuarantineStatus getQuarantineStatus(RepositoryComponentEvaluationDataList results) {
        return ((RepositoryComponentEvaluationData)results.componentEvalResults.get((int)0)).quarantine ? QuarantineStatus.DENY : QuarantineStatus.ALLOW;
    }
}

