/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.clm.internal.RepositoryAttributeStorage;
import java.util.function.BiPredicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;

@Named
@Singleton
public class IsAssetQuarantinable
implements BiPredicate<Repository, Asset> {
    private final RepositoryAttributeStorage repositoryAttributeStorage;

    @Inject
    public IsAssetQuarantinable(RepositoryAttributeStorage repositoryAttributeStorage) {
        this.repositoryAttributeStorage = (RepositoryAttributeStorage)Preconditions.checkNotNull((Object)repositoryAttributeStorage);
    }

    @Override
    public boolean test(Repository repository, Asset asset) {
        long quarantineThreshold;
        DateTime blobUpdatedTime;
        Long quarantineEnabledTime = this.repositoryAttributeStorage.getQuarantineEnabledTime(repository.getName());
        return quarantineEnabledTime != null && (blobUpdatedTime = asset.blobUpdated()) != null && !blobUpdatedTime.isBefore(quarantineThreshold = quarantineEnabledTime + 1000L);
    }
}

